/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.common.worldgen;

import alabaster.crabbersdelight.common.worldgen.CDPlacedFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class CDBiomeModifiers {
    public static final ResourceKey<BiomeModifier> ADD_TREE_PALM = CDBiomeModifiers.registerKey("add_tree_palm");
    public static final ResourceKey<BiomeModifier> ADD_SEASHELLS = CDBiomeModifiers.registerKey("add_seashells");
    public static final ResourceKey<BiomeModifier> ADD_SEASHELLS_UNDERWATER = CDBiomeModifiers.registerKey("add_seashells_underwater");

    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter biomes = context.lookup(Registries.BIOME);
        context.register(ADD_TREE_PALM, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.BEACH)}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(CDPlacedFeatures.PALM_PLACED_KEY)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_SEASHELLS, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.BEACH)}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(CDPlacedFeatures.SEASHELLS_PLACED_KEY)}), GenerationStep.Decoration.VEGETAL_DECORATION));
        context.register(ADD_SEASHELLS_UNDERWATER, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.direct((Holder[])new Holder[]{biomes.getOrThrow(Biomes.OCEAN), biomes.getOrThrow(Biomes.WARM_OCEAN), biomes.getOrThrow(Biomes.LUKEWARM_OCEAN), biomes.getOrThrow(Biomes.DEEP_LUKEWARM_OCEAN)}), (HolderSet)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(CDPlacedFeatures.SEASHELLS_PLACED_KEY_UNDERWATER)}), GenerationStep.Decoration.VEGETAL_DECORATION));
    }

    private static ResourceKey<BiomeModifier> registerKey(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"crabbersdelight", (String)name));
    }
}

