/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.simibubi.create.foundation.utility.CameraAngleAnimationService;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;

public class CameraAngleCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.literal((String)"angle").requires(cs -> cs.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.literal((String)"yaw").then(Commands.argument((String)"degrees", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> CameraAngleCommand.updateCameraAngle((CommandContext<CommandSourceStack>)context, true))))).then(Commands.literal((String)"pitch").then(Commands.argument((String)"degrees", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> CameraAngleCommand.updateCameraAngle((CommandContext<CommandSourceStack>)context, false))))).then(((LiteralArgumentBuilder)Commands.literal((String)"mode").then(((LiteralArgumentBuilder)Commands.literal((String)"linear").executes(context -> CameraAngleCommand.updateCameraAnimationMode((CommandContext<CommandSourceStack>)context, CameraAngleAnimationService.Mode.LINEAR.name()))).then(Commands.argument((String)"speed", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(context -> CameraAngleCommand.updateCameraAnimationMode((CommandContext<CommandSourceStack>)context, CameraAngleAnimationService.Mode.LINEAR.name(), FloatArgumentType.getFloat((CommandContext)context, (String)"speed")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"exponential").executes(context -> CameraAngleCommand.updateCameraAnimationMode((CommandContext<CommandSourceStack>)context, CameraAngleAnimationService.Mode.EXPONENTIAL.name()))).then(Commands.argument((String)"speed", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(context -> CameraAngleCommand.updateCameraAnimationMode((CommandContext<CommandSourceStack>)context, CameraAngleAnimationService.Mode.EXPONENTIAL.name(), FloatArgumentType.getFloat((CommandContext)context, (String)"speed")))))));
    }

    private static int updateCameraAngle(CommandContext<CommandSourceStack> ctx, boolean yaw) throws CommandSyntaxException {
        AtomicInteger targets = new AtomicInteger(0);
        float angleTarget = FloatArgumentType.getFloat(ctx, (String)"degrees");
        String optionName = yaw ? "camAngleYawTarget" : "camAnglePitchTarget";
        CameraAngleCommand.getPlayersFromContext(ctx).forEach(player -> {
            CatnipServices.NETWORK.simpleActionToClient(player, optionName, String.valueOf(angleTarget));
            targets.incrementAndGet();
        });
        return targets.get();
    }

    private static int updateCameraAnimationMode(CommandContext<CommandSourceStack> ctx, String value) throws CommandSyntaxException {
        AtomicInteger targets = new AtomicInteger(0);
        CameraAngleCommand.getPlayersFromContext(ctx).forEach(player -> {
            CatnipServices.NETWORK.simpleActionToClient(player, "camAngleFunction", value);
            targets.incrementAndGet();
        });
        return targets.get();
    }

    private static int updateCameraAnimationMode(CommandContext<CommandSourceStack> ctx, String value, float speed) throws CommandSyntaxException {
        AtomicInteger targets = new AtomicInteger(0);
        CameraAngleCommand.getPlayersFromContext(ctx).forEach(player -> {
            CatnipServices.NETWORK.simpleActionToClient(player, "camAngleFunction", value + ":" + speed);
            targets.incrementAndGet();
        });
        return targets.get();
    }

    private static Collection<ServerPlayer> getPlayersFromContext(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return EntityArgument.getPlayers(ctx, (String)"players");
    }
}

