/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.network.packets;

import com.pedrorok.hypertube.core.travel.ClientTravelPathMover;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record MovePathPacket(int entityId, List<Vec3> pathPoints, Set<BlockPos> actionPoints, double travelSpeed) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<MovePathPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"create_hypertube", (String)"entity_travel_path"));
    public static final StreamCodec<RegistryFriendlyByteBuf, MovePathPacket> STREAM_CODEC = StreamCodec.of(MovePathPacket::encode, MovePathPacket::decode);

    public static void encode(FriendlyByteBuf buf, MovePathPacket packet) {
        buf.writeInt(packet.entityId);
        buf.writeInt(packet.pathPoints.size());
        for (Vec3 vec : packet.pathPoints) {
            buf.writeDouble(vec.x);
            buf.writeDouble(vec.y);
            buf.writeDouble(vec.z);
        }
        buf.writeInt(packet.actionPoints.size());
        for (BlockPos blockPos : packet.actionPoints) {
            buf.writeBlockPos(blockPos);
        }
        buf.writeDouble(packet.travelSpeed);
    }

    public static MovePathPacket decode(FriendlyByteBuf buf) {
        int id = buf.readInt();
        int size = buf.readInt();
        ArrayList<Vec3> points = new ArrayList<Vec3>();
        for (int i = 0; i < size; ++i) {
            double x = buf.readDouble();
            double y = buf.readDouble();
            double z = buf.readDouble();
            points.add(new Vec3(x, y, z));
        }
        size = buf.readInt();
        HashSet<BlockPos> actionPoints = new HashSet<BlockPos>();
        for (int i = 0; i < size; ++i) {
            actionPoints.add(buf.readBlockPos());
        }
        double speed = buf.readDouble();
        return new MovePathPacket(id, points, actionPoints, speed);
    }

    public static void handle(MovePathPacket packet, IPayloadContext ctx) {
        ctx.enqueueWork(() -> ClientTravelPathMover.startMoving(packet));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

