/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.items;

import com.pedrorok.hypertube.core.connection.SimpleConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnection;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeConnectionEntity;
import com.pedrorok.hypertube.core.placement.ResponseDTO;
import com.pedrorok.hypertube.core.placement.TubePlacement;
import com.pedrorok.hypertube.registry.ModDataComponent;
import com.pedrorok.hypertube.utils.MessageUtils;
import com.simibubi.create.AllDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class HypertubeItem
extends BlockItem {
    public HypertubeItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        ItemStack stack = pContext.getItemInHand();
        BlockPos pos = pContext.getClickedPos();
        Level level = pContext.getLevel();
        BlockState state = level.getBlockState(pos);
        Player player = pContext.getPlayer();
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        if (player == null) {
            return super.useOn(pContext);
        }
        if (pContext.getHand() == InteractionHand.OFF_HAND) {
            return super.useOn(pContext);
        }
        if (player.isShiftKeyDown() && !this.isFoil(stack)) {
            return super.useOn(pContext);
        }
        Direction direction = pContext.getClickedFace();
        MessageUtils.sendActionMessage(player, "");
        if (!this.isFoil(stack)) {
            ResponseDTO select = HypertubeItem.select((LevelAccessor)level, pos, direction, stack);
            if (select.valid()) {
                level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 0.75f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (!select.errorMessage().isEmpty()) {
                MessageUtils.sendActionMessage(player, (Component)select.getMessageComponent());
            }
            return super.useOn(pContext);
        }
        SimpleConnection simpleConnection = (SimpleConnection)stack.get(ModDataComponent.TUBE_CONNECTING_FROM);
        if (player.isShiftKeyDown()) {
            MessageUtils.sendActionMessage(player, (Component)Component.translatable((String)"placement.create_hypertube.conn_cleared").withColor(0xFFFF00));
            HypertubeItem.clearConnection(stack);
            return InteractionResult.SUCCESS;
        }
        if (simpleConnection.pos().equals((Object)pos)) {
            player.playSound(SoundEvents.ITEM_FRAME_REMOVE_ITEM, 1.0f, 1.0f);
            return InteractionResult.FAIL;
        }
        boolean isHypertubeClicked = state.getBlock() instanceof ITubeConnection;
        boolean success = false;
        if (isHypertubeClicked) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof ITubeConnectionEntity) {
                ITubeConnectionEntity tube = (ITubeConnectionEntity)blockEntity;
                success = TubePlacement.handleHypertubeClicked(tube, player, simpleConnection, pos, direction, level, stack);
            }
            SoundType soundtype = state.getSoundType();
            if (success) {
                level.playSound(null, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
            } else {
                level.playSound(player, pos, (SoundEvent)SoundEvents.NOTE_BLOCK_BASS.value(), SoundSource.BLOCKS, 1.0f, 0.5f);
            }
        }
        return isHypertubeClicked ? InteractionResult.FAIL : super.useOn(pContext);
    }

    public static ResponseDTO select(LevelAccessor world, BlockPos pos, Direction direction, ItemStack heldItem) {
        BlockState blockState = world.getBlockState(pos);
        Block block = blockState.getBlock();
        if (!(block instanceof ITubeConnection)) {
            return ResponseDTO.get(false);
        }
        ITubeConnection tube = (ITubeConnection)block;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof ITubeConnectionEntity)) {
            return ResponseDTO.get(false);
        }
        ITubeConnectionEntity blockEntity2 = (ITubeConnectionEntity)blockEntity;
        if (!blockEntity2.getFacesConnectable().contains(direction) || tube.isConnected(world, pos, direction)) {
            return ResponseDTO.get(false, "placement.create_hypertube.cant_conn_to_face");
        }
        heldItem.set(ModDataComponent.TUBE_CONNECTING_FROM, (Object)new SimpleConnection(pos, direction));
        heldItem.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, (Object)true);
        return ResponseDTO.get(true);
    }

    public static void clearConnection(ItemStack stack) {
        stack.remove(ModDataComponent.TUBE_CONNECTING_FROM);
        stack.remove(DataComponents.ENCHANTMENT_GLINT_OVERRIDE);
    }

    public boolean isFoil(ItemStack stack) {
        return stack.has(AllDataComponents.TRACK_CONNECTING_FROM) || stack.has(DataComponents.ENCHANTMENT_GLINT_OVERRIDE);
    }
}

