/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.core.smarttube;

import com.pedrorok.hypertube.blocks.ActionTubeBlock;
import com.pedrorok.hypertube.blocks.blockentities.ActionTubeBlockEntity;
import com.pedrorok.hypertube.core.connection.interfaces.ITubeActionPoint;
import com.pedrorok.hypertube.core.smarttube.ITubeAttachment;
import com.pedrorok.hypertube.registry.ModItems;
import com.pedrorok.hypertube.registry.ModPartialModels;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TubeScannerAttachment
implements ITubeAttachment {
    @Override
    public String getId() {
        return "tube_scanner";
    }

    @Override
    public boolean emitRedstoneSignal() {
        return true;
    }

    @Override
    public PartialModel getPartialModel(BlockState blockState, ActionTubeBlockEntity blockEntity, Direction facing) {
        if ((Integer)blockState.getValue((Property)ActionTubeBlock.POWER) > 0) {
            return ModPartialModels.TUBE_SCANNER_ACTIVE;
        }
        return ModPartialModels.TUBE_SCANNER;
    }

    @Override
    public ITubeActionPoint getActionPoint(Direction attachedDirection) {
        return (entity, mover, pos) -> {
            Level level = entity.level();
            if (level.isClientSide) {
                return;
            }
            BlockState currentState = level.getBlockState(pos);
            if (currentState.hasProperty((Property)ActionTubeBlock.POWER)) {
                int newPower;
                int currentPower = (Integer)currentState.getValue((Property)ActionTubeBlock.POWER);
                int n = newPower = entity.isBaby() ? 8 : 15;
                if (newPower >= currentPower) {
                    if (newPower != currentPower) {
                        level.setBlock(pos, (BlockState)currentState.setValue((Property)ActionTubeBlock.POWER, (Comparable)Integer.valueOf(newPower)), 3);
                    }
                    level.scheduleTick(pos, currentState.getBlock(), 20);
                    level.updateNeighborsAt(pos, currentState.getBlock());
                }
            }
        };
    }

    @Override
    public ItemStack getItemStack() {
        return ModItems.TUBE_SCANNER.asStack();
    }
}

