/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.herbalbrews.core.blocks.BonemealableFlowerBlock;
import net.satisfy.herbalbrews.core.blocks.CauldronBlock;
import net.satisfy.herbalbrews.core.blocks.CoffeeCropBlock;
import net.satisfy.herbalbrews.core.blocks.CompletionistBannerBlock;
import net.satisfy.herbalbrews.core.blocks.CompletionistWallBannerBlock;
import net.satisfy.herbalbrews.core.blocks.JugBlock;
import net.satisfy.herbalbrews.core.blocks.RooibosCropBlock;
import net.satisfy.herbalbrews.core.blocks.StoveBlock;
import net.satisfy.herbalbrews.core.blocks.TeaCropBlock;
import net.satisfy.herbalbrews.core.blocks.TeaCupBlock;
import net.satisfy.herbalbrews.core.blocks.TeaKettleBlock;
import net.satisfy.herbalbrews.core.blocks.TeaLeafBlock;
import net.satisfy.herbalbrews.core.blocks.YerbaMateCropBlock;
import net.satisfy.herbalbrews.core.items.DrinkBlockItem;
import net.satisfy.herbalbrews.core.items.FlaskItem;
import net.satisfy.herbalbrews.core.items.HatItem;
import net.satisfy.herbalbrews.core.items.JugItem;
import net.satisfy.herbalbrews.core.util.HerbalBrewsIdentifier;
import net.satisfy.herbalbrews.core.util.HerbalBrewsUtil;

public class ObjectRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"herbalbrews", (ResourceKey)Registries.ITEM);
    public static final Registrar<Item> ITEM_REGISTRAR = ITEMS.getRegistrar();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"herbalbrews", (ResourceKey)Registries.BLOCK);
    public static final Registrar<Block> BLOCK_REGISTRAR = BLOCKS.getRegistrar();
    public static final RegistrySupplier<Block> STOVE = ObjectRegistry.registerWithItem("stove", () -> new StoveBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRICKS).lightLevel(state -> (Boolean)state.getValue((Property)StoveBlock.LIT) != false ? 13 : 0).randomTicks()));
    public static final RegistrySupplier<Block> TEA_LEAF_CRATE = ObjectRegistry.registerWithItem("tea_leaf_crate", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RED_WOOL)));
    public static final RegistrySupplier<Block> GREEN_TEA_LEAF_BLOCK = ObjectRegistry.registerWithItem("green_tea_leaf_block", () -> new TeaLeafBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_LEAVES)));
    public static final RegistrySupplier<Block> DRIED_GREEN_TEA_LEAF_BLOCK = ObjectRegistry.registerWithItem("dried_green_tea_leaf_block", () -> new TeaLeafBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_LEAVES)));
    public static final RegistrySupplier<Block> DRIED_OUT_GREEN_TEA_LEAF_BLOCK = ObjectRegistry.registerWithItem("dried_out_green_tea_leaf_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_LEAVES)));
    public static final RegistrySupplier<Block> BLACK_TEA_LEAF_BLOCK = ObjectRegistry.registerWithItem("black_tea_leaf_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_LEAVES)));
    public static final RegistrySupplier<Block> MIXED_TEA_LEAF_BLOCK = ObjectRegistry.registerWithItem("mixed_tea_leaf_block", () -> new TeaLeafBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_LEAVES)));
    public static final RegistrySupplier<Block> OOLONG_TEA_LEAF_BLOCK = ObjectRegistry.registerWithItem("oolong_tea_leaf_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_LEAVES)));
    public static final RegistrySupplier<Block> WILD_COFFEE_PLANT = ObjectRegistry.registerWithItem("wild_coffee_plant", () -> new FlowerBlock(MobEffects.HEAL, 1.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION)));
    public static final RegistrySupplier<Block> COFFEE_PLANT = ObjectRegistry.registerWithoutItem("coffee_plant", () -> new CoffeeCropBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SWEET_BERRY_BUSH)));
    public static final RegistrySupplier<Block> WILD_ROOIBOS_PLANT = ObjectRegistry.registerWithItem("wild_rooibos_plant", () -> new FlowerBlock(MobEffects.HEAL, 1.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION)));
    public static final RegistrySupplier<Block> ROOIBOS_PLANT = ObjectRegistry.registerWithoutItem("rooibos_plant", () -> new RooibosCropBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SWEET_BERRY_BUSH)));
    public static final RegistrySupplier<Block> WILD_YERBA_MATE_PLANT = ObjectRegistry.registerWithItem("wild_yerba_mate_plant", () -> new FlowerBlock(MobEffects.HEAL, 1.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION)));
    public static final RegistrySupplier<Block> YERBA_MATE_PLANT = ObjectRegistry.registerWithoutItem("yerba_mate_plant", () -> new YerbaMateCropBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SWEET_BERRY_BUSH)));
    public static final RegistrySupplier<Block> TEA_PLANT = ObjectRegistry.registerWithoutItem("tea_plant", () -> new TeaCropBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SWEET_BERRY_BUSH)));
    public static final RegistrySupplier<Block> HIBISCUS = ObjectRegistry.registerWithItem("hibiscus", () -> new BonemealableFlowerBlock((Holder<MobEffect>)MobEffects.HEAL, 1.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION)));
    public static final RegistrySupplier<Block> LAVENDER = ObjectRegistry.registerWithItem("lavender", () -> new BonemealableFlowerBlock((Holder<MobEffect>)MobEffects.HEAL, 1.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DANDELION)));
    public static final RegistrySupplier<Block> JUG = ObjectRegistry.registerWithoutItem("jug", () -> new JugBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS)));
    public static final RegistrySupplier<Item> JUG_ITEM = ObjectRegistry.registerItem("jug", () -> new JugItem((Block)JUG.get(), ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Block> COPPER_TEA_KETTLE = ObjectRegistry.registerWithItem("copper_tea_kettle", () -> new TeaKettleBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final RegistrySupplier<Block> TEA_KETTLE = ObjectRegistry.registerWithItem("tea_kettle", () -> new TeaKettleBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK)));
    public static final RegistrySupplier<Block> CAULDRON = ObjectRegistry.registerWithItem("cauldron", () -> new CauldronBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).lightLevel(blockState -> 11)));
    public static final RegistrySupplier<Item> FLASK = ObjectRegistry.registerItem("flask", () -> new FlaskItem(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> TEA_BLOSSOM = ObjectRegistry.registerItem("tea_blossom", () -> new BlockItem((Block)TEA_PLANT.get(), ObjectRegistry.getSettings().food(new FoodProperties.Builder().nutrition(1).saturationModifier(0.1f).fast().alwaysEdible().build())));
    public static final RegistrySupplier<Item> GREEN_TEA_LEAF = ObjectRegistry.registerItem("green_tea_leaf", () -> new Item(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> YERBA_MATE_LEAF = ObjectRegistry.registerItem("yerba_mate_leaf", () -> new BlockItem((Block)YERBA_MATE_PLANT.get(), ObjectRegistry.getSettings().food(new FoodProperties.Builder().nutrition(1).saturationModifier(0.1f).fast().alwaysEdible().build())));
    public static final RegistrySupplier<Item> ROOIBOS_LEAF = ObjectRegistry.registerItem("rooibos_leaf", () -> new BlockItem((Block)ROOIBOS_PLANT.get(), ObjectRegistry.getSettings().food(new FoodProperties.Builder().nutrition(1).saturationModifier(0.1f).fast().alwaysEdible().build())));
    public static final RegistrySupplier<Item> LAVENDER_BLOSSOM = ObjectRegistry.registerItem("lavender_blossom", () -> new Item(ObjectRegistry.getSettings()));
    public static final RegistrySupplier<Item> DRIED_GREEN_TEA = ObjectRegistry.registerItem("dried_green_tea", () -> new Item(ObjectRegistry.getSettings().food(new FoodProperties.Builder().nutrition(1).saturationModifier(0.1f).fast().alwaysEdible().build())));
    public static final RegistrySupplier<Item> DRIED_BLACK_TEA = ObjectRegistry.registerItem("dried_black_tea", () -> new Item(ObjectRegistry.getSettings().food(new FoodProperties.Builder().nutrition(1).saturationModifier(0.1f).fast().alwaysEdible().build())));
    public static final RegistrySupplier<Item> DRIED_OOLONG_TEA = ObjectRegistry.registerItem("dried_oolong_tea", () -> new Item(ObjectRegistry.getSettings().food(new FoodProperties.Builder().nutrition(1).saturationModifier(0.1f).fast().alwaysEdible().build())));
    public static final RegistrySupplier<Item> COFFEE_BEANS = ObjectRegistry.registerItem("coffee_beans", () -> new BlockItem((Block)COFFEE_PLANT.get(), ObjectRegistry.getSettings().food(new FoodProperties.Builder().nutrition(1).saturationModifier(0.1f).fast().alwaysEdible().build())));
    public static final RegistrySupplier<Block> GREEN_TEA_BLOCK = ObjectRegistry.registerWithoutItem("green_tea_block", () -> new TeaCupBlock(ObjectRegistry.getTeaSettings()));
    public static final RegistrySupplier<Block> BLACK_TEA_BLOCK = ObjectRegistry.registerWithoutItem("black_tea_block", () -> new TeaCupBlock(ObjectRegistry.getTeaSettings()));
    public static final RegistrySupplier<Block> LAVENDER_TEA_BLOCK = ObjectRegistry.registerWithoutItem("lavender_tea_block", () -> new TeaCupBlock(ObjectRegistry.getTeaSettings()));
    public static final RegistrySupplier<Block> YERBA_MATE_TEA_BLOCK = ObjectRegistry.registerWithoutItem("yerba_mate_tea_block", () -> new TeaCupBlock(ObjectRegistry.getTeaSettings()));
    public static final RegistrySupplier<Block> OOLONG_TEA_BLOCK = ObjectRegistry.registerWithoutItem("oolong_tea_block", () -> new TeaCupBlock(ObjectRegistry.getTeaSettings()));
    public static final RegistrySupplier<Block> ROOIBOS_TEA_BLOCK = ObjectRegistry.registerWithoutItem("rooibos_tea_block", () -> new TeaCupBlock(ObjectRegistry.getTeaSettings()));
    public static final RegistrySupplier<Block> HIBISCUS_TEA_BLOCK = ObjectRegistry.registerWithoutItem("hibiscus_tea_block", () -> new TeaCupBlock(ObjectRegistry.getTeaSettings()));
    public static final RegistrySupplier<Block> MILK_COFFEE_BLOCK = ObjectRegistry.registerWithoutItem("milk_coffee_block", () -> new TeaCupBlock(ObjectRegistry.getTeaSettings()));
    public static final RegistrySupplier<Block> COFFEE_BLOCK = ObjectRegistry.registerWithoutItem("coffee_block", () -> new TeaCupBlock(ObjectRegistry.getTeaSettings()));
    public static final RegistrySupplier<Item> GREEN_TEA = ObjectRegistry.registerItem("green_tea", () -> new DrinkBlockItem((Block)GREEN_TEA_BLOCK.get(), ObjectRegistry.getSettings().food(new FoodProperties.Builder().nutrition(Foods.SWEET_BERRIES.nutrition()).saturationModifier(Foods.SWEET_BERRIES.saturation()).alwaysEdible().build())));
    public static final RegistrySupplier<Item> BLACK_TEA = ObjectRegistry.registerItem("black_tea", () -> new DrinkBlockItem((Block)BLACK_TEA_BLOCK.get(), ObjectRegistry.getSettings().food(new FoodProperties.Builder().nutrition(Foods.SWEET_BERRIES.nutrition()).saturationModifier(Foods.SWEET_BERRIES.saturation()).alwaysEdible().build())));
    public static final RegistrySupplier<Item> LAVENDER_TEA = ObjectRegistry.registerItem("lavender_tea", () -> new DrinkBlockItem((Block)LAVENDER_TEA_BLOCK.get(), ObjectRegistry.getSettings().food(new FoodProperties.Builder().nutrition(Foods.SWEET_BERRIES.nutrition()).saturationModifier(Foods.SWEET_BERRIES.saturation()).alwaysEdible().build())));
    public static final RegistrySupplier<Item> YERBA_MATE_TEA = ObjectRegistry.registerItem("yerba_mate_tea", () -> new DrinkBlockItem((Block)YERBA_MATE_TEA_BLOCK.get(), ObjectRegistry.getSettings().food(new FoodProperties.Builder().nutrition(Foods.SWEET_BERRIES.nutrition()).saturationModifier(Foods.SWEET_BERRIES.saturation()).alwaysEdible().build())));
    public static final RegistrySupplier<Item> OOLONG_TEA = ObjectRegistry.registerItem("oolong_tea", () -> new DrinkBlockItem((Block)OOLONG_TEA_BLOCK.get(), ObjectRegistry.getSettings().food(new FoodProperties.Builder().nutrition(Foods.SWEET_BERRIES.nutrition()).saturationModifier(Foods.SWEET_BERRIES.saturation()).alwaysEdible().build())));
    public static final RegistrySupplier<Item> ROOIBOS_TEA = ObjectRegistry.registerItem("rooibos_tea", () -> new DrinkBlockItem((Block)ROOIBOS_TEA_BLOCK.get(), ObjectRegistry.getSettings().food(new FoodProperties.Builder().nutrition(Foods.SWEET_BERRIES.nutrition()).saturationModifier(Foods.SWEET_BERRIES.saturation()).alwaysEdible().build())));
    public static final RegistrySupplier<Item> HIBISCUS_TEA = ObjectRegistry.registerItem("hibiscus_tea", () -> new DrinkBlockItem((Block)HIBISCUS_TEA_BLOCK.get(), ObjectRegistry.getSettings().food(new FoodProperties.Builder().nutrition(Foods.SWEET_BERRIES.nutrition()).saturationModifier(Foods.SWEET_BERRIES.saturation()).alwaysEdible().build())));
    public static final RegistrySupplier<Item> MILK_COFFEE = ObjectRegistry.registerItem("milk_coffee", () -> new DrinkBlockItem((Block)MILK_COFFEE_BLOCK.get(), ObjectRegistry.getSettings().food(new FoodProperties.Builder().nutrition(Foods.SWEET_BERRIES.nutrition()).saturationModifier(Foods.SWEET_BERRIES.saturation()).alwaysEdible().build())));
    public static final RegistrySupplier<Item> COFFEE = ObjectRegistry.registerItem("coffee", () -> new DrinkBlockItem((Block)COFFEE_BLOCK.get(), ObjectRegistry.getSettings().food(new FoodProperties.Builder().nutrition(Foods.SWEET_BERRIES.nutrition()).saturationModifier(Foods.SWEET_BERRIES.saturation()).alwaysEdible().build())));
    public static final RegistrySupplier<Item> WITCH_HAT = ObjectRegistry.registerItem("witch_hat", () -> new HatItem((Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.HELMET, new Item.Properties().rarity(Rarity.EPIC), HerbalBrewsIdentifier.identifier("textures/models/armor/witch_hat.png")));
    public static final RegistrySupplier<Item> TOP_HAT = ObjectRegistry.registerItem("top_hat", () -> new HatItem((Holder<ArmorMaterial>)ArmorMaterials.LEATHER, ArmorItem.Type.HELMET, new Item.Properties().rarity(Rarity.EPIC), HerbalBrewsIdentifier.identifier("textures/models/armor/top_hat.png")));
    public static final RegistrySupplier<Block> HERBALBREWS_BANNER = ObjectRegistry.registerWithItem("herbalbrews_banner", () -> new CompletionistBannerBlock(BlockBehaviour.Properties.of().strength(1.0f).instrument(NoteBlockInstrument.BASS).noCollission().sound(SoundType.WOOD)));
    public static final RegistrySupplier<Block> HERBALBREWS_WALL_BANNER = ObjectRegistry.registerWithoutItem("herbalbrews_wall_banner", () -> new CompletionistWallBannerBlock(BlockBehaviour.Properties.of().strength(1.0f).instrument(NoteBlockInstrument.BASS).noCollission().sound(SoundType.WOOD)));
    public static final RegistrySupplier<Block> POTTED_LAVENDER = ObjectRegistry.registerWithoutItem("potted_lavender", () -> new FlowerPotBlock((Block)LAVENDER.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT)));
    public static final RegistrySupplier<Block> POTTED_HIBISCUS = ObjectRegistry.registerWithoutItem("potted_hibiscus", () -> new FlowerPotBlock((Block)HIBISCUS.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT)));
    public static final RegistrySupplier<Block> POTTED_WILD_ROOIBOS = ObjectRegistry.registerWithoutItem("potted_wild_rooibos", () -> new FlowerPotBlock((Block)WILD_ROOIBOS_PLANT.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT)));
    public static final RegistrySupplier<Block> POTTED_WILD_COFFEE = ObjectRegistry.registerWithoutItem("potted_wild_coffee", () -> new FlowerPotBlock((Block)WILD_COFFEE_PLANT.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT)));
    public static final RegistrySupplier<Block> POTTED_WILD_YERBA_MATE = ObjectRegistry.registerWithoutItem("potted_wild_yerba_mate", () -> new FlowerPotBlock((Block)WILD_YERBA_MATE_PLANT.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.FLOWER_POT)));
    public static final RegistrySupplier<Item> HERBAL_INFUSION = ObjectRegistry.registerItem("herbal_infusion", () -> new Item(ObjectRegistry.getSettings()));

    public static void init() {
        ITEMS.register();
        BLOCKS.register();
    }

    private static Item.Properties getSettings(Consumer<Item.Properties> consumer) {
        Item.Properties settings = new Item.Properties();
        consumer.accept(settings);
        return settings;
    }

    static Item.Properties getSettings() {
        return ObjectRegistry.getSettings(settings -> {});
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(String name, Supplier<T> block) {
        return HerbalBrewsUtil.registerWithItem(BLOCKS, BLOCK_REGISTRAR, ITEMS, ITEM_REGISTRAR, HerbalBrewsIdentifier.identifier(name), block);
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(String path, Supplier<T> block) {
        return HerbalBrewsUtil.registerWithoutItem(BLOCKS, BLOCK_REGISTRAR, HerbalBrewsIdentifier.identifier(path), block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(String path, Supplier<T> itemSupplier) {
        return HerbalBrewsUtil.registerItem(ITEMS, ITEM_REGISTRAR, HerbalBrewsIdentifier.identifier(path), itemSupplier);
    }

    private static BlockBehaviour.Properties getTeaSettings() {
        return BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).noOcclusion().instabreak();
    }
}

