/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.effects;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class FortuneEffect
extends MobEffect {
    public FortuneEffect() {
        super(MobEffectCategory.BENEFICIAL, 65280);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).isAlive()) {
            int finalAmplifier;
            Level world = player.level();
            double radius = 10.0;
            List nearbyPlayers = world.getEntitiesOfClass(Player.class, player.getBoundingBox().inflate(radius));
            int playerCount = nearbyPlayers.size() - 1;
            if (playerCount < 0) {
                playerCount = 0;
            }
            if ((finalAmplifier = this.calculateFinalAmplifier(playerCount)) > 0) {
                double fortuneModifierValue = 1.0 * (double)(finalAmplifier + 1);
                AttributeInstance luckAttr = player.getAttribute(Attributes.LUCK);
                if (luckAttr != null) {
                    AttributeModifier existingModifier = luckAttr.getModifier(ResourceLocation.withDefaultNamespace((String)"effect.luck"));
                    if (existingModifier != null) {
                        if (existingModifier.amount() != fortuneModifierValue) {
                            luckAttr.removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.luck"));
                            AttributeModifier fortuneModifier = new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"effect.luck"), fortuneModifierValue, AttributeModifier.Operation.ADD_VALUE);
                            luckAttr.addPermanentModifier(fortuneModifier);
                        }
                    } else {
                        AttributeModifier fortuneModifier = new AttributeModifier(ResourceLocation.withDefaultNamespace((String)"effect.luck"), fortuneModifierValue, AttributeModifier.Operation.ADD_VALUE);
                        luckAttr.addPermanentModifier(fortuneModifier);
                    }
                }
            } else {
                AttributeInstance luckAttr = player.getAttribute(Attributes.LUCK);
                if (luckAttr != null) {
                    luckAttr.removeModifier(ResourceLocation.withDefaultNamespace((String)"effect.luck"));
                }
            }
        }
        return super.applyEffectTick(entity, amplifier);
    }

    private int calculateFinalAmplifier(int playerCount) {
        float baseAmplifier = 1.0f;
        float reductionPerPlayer = 0.1f;
        float calculatedAmplifier = baseAmplifier - (float)playerCount * reductionPerPlayer;
        if (calculatedAmplifier < 0.0f) {
            calculatedAmplifier = 0.0f;
        }
        int finalAmplifier = Math.round(calculatedAmplifier);
        return Math.max(0, Math.min(finalAmplifier, 3));
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int j) {
        return true;
    }
}

