/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.biome;

import com.epherical.croptopia.CroptopiaMod;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.world.BiomeGenerationSettingsBuilder;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import net.neoforged.neoforge.registries.DeferredHolder;

public record SaltModifier(GenerationStep.Decoration step, Holder<PlacedFeature> features) implements BiomeModifier
{
    public static final DeferredHolder<MapCodec<? extends BiomeModifier>, MapCodec<SaltModifier>> SERIALIZER = CroptopiaMod.BIOME_SERIALIZER.register("salt", SaltModifier::makeCodec);

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && CroptopiaMod.config.generateSaltInWorld && !biome.is(Tags.Biomes.IS_SWAMP)) {
            BiomeGenerationSettingsBuilder generation = builder.getGenerationSettings();
            generation.addFeature(this.step, this.features);
        }
    }

    public MapCodec<? extends BiomeModifier> codec() {
        return (MapCodec)SERIALIZER.get();
    }

    public static MapCodec<SaltModifier> makeCodec() {
        return RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.comapFlatMap(SaltModifier::generationStageFromString, GenerationStep.Decoration::getName).fieldOf("generation_stage").forGetter(SaltModifier::step), (App)PlacedFeature.CODEC.fieldOf("feature").forGetter(SaltModifier::features)).apply((Applicative)builder, SaltModifier::new));
    }

    private static DataResult<GenerationStep.Decoration> generationStageFromString(String name) {
        try {
            return DataResult.success((Object)GenerationStep.Decoration.valueOf((String)name.toUpperCase(Locale.ROOT)));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Not a decoration stage: " + name);
        }
    }
}

