/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.amendments.common.block.WaterloggedLilyBlock;
import net.mehvahdjukaar.amendments.common.tile.WaterloggedLilyBlockTile;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadsTransformer;
import net.mehvahdjukaar.moonlight.api.client.model.CustomBakedModel;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WaterloggedLilyModel
implements CustomBakedModel {
    private final BlockModelShaper blockModelShaper = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper();

    public List<BakedQuad> getBlockQuads(BlockState state, Direction side, RandomSource rand, RenderType renderType, ExtraModelData data) {
        BlockState mimic = (BlockState)data.get(WaterloggedLilyBlockTile.MIMIC_KEY);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (mimic != null && !mimic.isAir()) {
            BakedModel model = this.blockModelShaper.getBlockModel(mimic);
            List mimicQuads = model.getQuads(mimic, side, rand);
            PoseStack pose = new PoseStack();
            double v = 1.0 + ((Boolean)state.getValue((Property)WaterloggedLilyBlock.EXTENDED) != false ? 0.0 : ClientConfigs.LILY_OFFSET.get());
            pose.translate(0.0f, (float)v, 0.0f);
            BakedQuadsTransformer transformer = BakedQuadsTransformer.create().applyingTransform(pose.last().pose());
            quads.addAll(transformer.transformAll(mimicQuads));
            return quads;
        }
        return quads;
    }

    public TextureAtlasSprite getBlockParticle(ExtraModelData data) {
        BlockState mimic = (BlockState)data.get(WaterloggedLilyBlockTile.MIMIC_KEY);
        if (mimic != null && !mimic.isAir()) {
            BakedModel model = this.blockModelShaper.getBlockModel(mimic);
            try {
                return model.getParticleIcon();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.blockModelShaper.getBlockModel(Blocks.LILY_PAD.defaultBlockState()).getParticleIcon();
    }

    public boolean useAmbientOcclusion() {
        return false;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean usesBlockLight() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    public ItemTransforms getTransforms() {
        return ItemTransforms.NO_TRANSFORMS;
    }
}

