/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.JukeboxSong;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;

public class SoundEventRegistry {
    public static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((String)"beachparty", (ResourceKey)Registries.SOUND_EVENT);
    public static final RegistrySupplier<SoundEvent> RADIO_CLICK = SoundEventRegistry.soundEvent("radio_click");
    public static final RegistrySupplier<SoundEvent> RADIO_TUNE = SoundEventRegistry.soundEvent("radio_tune");
    public static final RegistrySupplier<SoundEvent> OVER_THE_RAINBOW_SE = SoundEventRegistry.soundEvent("over_the_rainbow");
    public static final RegistrySupplier<SoundEvent> BEACHPARTY_SE = SoundEventRegistry.soundEvent("beachparty");
    public static final RegistrySupplier<SoundEvent> CARIBBEAN_BEACH_SE = SoundEventRegistry.soundEvent("caribbean_beach");
    public static final RegistrySupplier<SoundEvent> PRIDELANDS_SE = SoundEventRegistry.soundEvent("pridelands");
    public static final RegistrySupplier<SoundEvent> VOCALISTA_SE = SoundEventRegistry.soundEvent("vocalista");
    public static final RegistrySupplier<SoundEvent> WILD_VEINS_SE = SoundEventRegistry.soundEvent("wild_veins");
    public static final ResourceKey<JukeboxSong> OVER_THE_RAINBOW = SoundEventRegistry.song("over_the_rainbow");
    public static final ResourceKey<JukeboxSong> BEACHPARTY = SoundEventRegistry.song("beachparty");
    public static final ResourceKey<JukeboxSong> CARIBBEAN_BEACH = SoundEventRegistry.song("caribbean_beach");
    public static final ResourceKey<JukeboxSong> PRIDELANDS = SoundEventRegistry.song("pridelands");
    public static final ResourceKey<JukeboxSong> VOCALISTA = SoundEventRegistry.song("vocalista");
    public static final ResourceKey<JukeboxSong> WILD_VEINS = SoundEventRegistry.song("wild_veins");
    public static final List<ResourceKey<JukeboxSong>> RADIO_SONGS = List.of(BEACHPARTY, CARIBBEAN_BEACH, PRIDELANDS, VOCALISTA, WILD_VEINS, OVER_THE_RAINBOW);

    private static RegistrySupplier<SoundEvent> soundEvent(String id) {
        ResourceLocation rl = BeachpartyIdentifier.identifier(id);
        return SOUND_EVENTS.register(rl, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)rl));
    }

    private static ResourceKey<JukeboxSong> song(String id) {
        return ResourceKey.create((ResourceKey)Registries.JUKEBOX_SONG, (ResourceLocation)BeachpartyIdentifier.identifier(id));
    }

    public static void init() {
        SOUND_EVENTS.register();
    }
}

