/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.registry;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.beachparty.core.block.entity.BeachGoalBlockEntity;
import net.satisfy.beachparty.core.block.entity.CompletionistBannerEntity;
import net.satisfy.beachparty.core.block.entity.MiniFridgeBlockEntity;
import net.satisfy.beachparty.core.block.entity.PalmBarBlockEntity;
import net.satisfy.beachparty.core.block.entity.PalmCabinetBlockEntity;
import net.satisfy.beachparty.core.block.entity.PalmHangingSignBlockEntity;
import net.satisfy.beachparty.core.block.entity.PalmSignBlockEntity;
import net.satisfy.beachparty.core.block.entity.RadioBlockEntity;
import net.satisfy.beachparty.core.block.entity.WetHayBaleBlockEntity;
import net.satisfy.beachparty.core.entity.BeachBallEntity;
import net.satisfy.beachparty.core.entity.ChairEntity;
import net.satisfy.beachparty.core.entity.PalmBoatEntity;
import net.satisfy.beachparty.core.entity.PalmChestBoatEntity;
import net.satisfy.beachparty.core.entity.ThrowableCoconutEntity;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;
import net.satisfy.beachparty.platform.PlatformHelper;

public class EntityTypeRegistry {
    private static final Registrar<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"beachparty", (ResourceKey)Registries.BLOCK_ENTITY_TYPE).getRegistrar();
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"beachparty", (ResourceKey)Registries.ENTITY_TYPE);
    public static final RegistrySupplier<EntityType<ChairEntity>> CHAIR = EntityTypeRegistry.registerEntity("chair", () -> EntityType.Builder.of(ChairEntity::new, (MobCategory)MobCategory.MISC).sized(0.001f, 0.001f).build(BeachpartyIdentifier.identifier("chair").toString()));
    public static final RegistrySupplier<EntityType<ThrowableCoconutEntity>> COCONUT = EntityTypeRegistry.registerEntity("coconut", () -> EntityType.Builder.of(ThrowableCoconutEntity::new, (MobCategory)MobCategory.MISC).sized(0.25f, 0.25f).build(BeachpartyIdentifier.identifier("coconut").toString()));
    public static final RegistrySupplier<EntityType<BeachBallEntity>> BEACH_BALL = EntityTypeRegistry.registerEntity("beach_ball", () -> EntityType.Builder.of(BeachBallEntity::new, (MobCategory)MobCategory.MISC).sized(0.4f, 0.4f).build(BeachpartyIdentifier.identifier("beach_ball").toString()));
    public static final Supplier<EntityType<PalmBoatEntity>> PALM_BOAT = PlatformHelper.registerBoatType("palm_boat", PalmBoatEntity::new, MobCategory.MISC, 1.375f, 0.5625f, 10);
    public static final Supplier<EntityType<PalmChestBoatEntity>> PALM_CHEST_BOAT = PlatformHelper.registerBoatType("palm_chest_boat", PalmChestBoatEntity::new, MobCategory.MISC, 1.375f, 0.5625f, 10);
    public static final RegistrySupplier<BlockEntityType<PalmSignBlockEntity>> BEACHPARTY_SIGN = EntityTypeRegistry.registerBlockEntity("beachparty_sign", () -> BlockEntityType.Builder.of(PalmSignBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.PALM_SIGN.get(), (Block)ObjectRegistry.PALM_WALL_SIGN.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<PalmHangingSignBlockEntity>> BEACHPARTY_HANGING_SIGN = EntityTypeRegistry.registerBlockEntity("beachparty_hanging_sign", () -> BlockEntityType.Builder.of(PalmHangingSignBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.PALM_HANGING_SIGN.get(), (Block)ObjectRegistry.PALM_WALL_HANGING_SIGN.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<MiniFridgeBlockEntity>> MINI_FRIDGE_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("mini_fridge", () -> BlockEntityType.Builder.of(MiniFridgeBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.MINI_FRIDGE.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<PalmCabinetBlockEntity>> CABINET_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("cabinet", () -> BlockEntityType.Builder.of(PalmCabinetBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.PALM_CABINET.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<PalmBarBlockEntity>> PALM_BAR_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("palm_bar", () -> BlockEntityType.Builder.of(PalmBarBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.PALM_BAR.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<BeachGoalBlockEntity>> BEACH_GOAL_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("beach_goal", () -> BlockEntityType.Builder.of(BeachGoalBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.BEACH_GOAL.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<WetHayBaleBlockEntity>> WET_HAY_BALE_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("wet_hay_bale", () -> BlockEntityType.Builder.of(WetHayBaleBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.WET_HAY_BLOCK.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<CompletionistBannerEntity>> BEACHPARTY_BANNER = EntityTypeRegistry.registerBlockEntity("beachparty_banner", () -> BlockEntityType.Builder.of(CompletionistBannerEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.BEACHPARTY_BANNER.get(), (Block)ObjectRegistry.BEACHPARTY_WALL_BANNER.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<RadioBlockEntity>> RADIO_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("radio", () -> BlockEntityType.Builder.of(RadioBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.RADIO.get()}).build(null));

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register(BeachpartyIdentifier.identifier(path), type);
    }

    private static <T extends EntityType<?>> RegistrySupplier<T> registerEntity(String path, Supplier<T> type) {
        return ENTITY_TYPES.register(path, type);
    }

    public static void registerAttributes() {
        EntityAttributeRegistry.register(BEACH_BALL, BeachBallEntity::createMobAttributes);
    }

    public static void init() {
        ENTITY_TYPES.register();
        EntityTypeRegistry.registerAttributes();
    }
}

