/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.satisfy.beachparty.core.registry.RecipeTypeRegistry;
import net.satisfy.beachparty.core.util.BeachpartyUtil;
import org.jetbrains.annotations.NotNull;

public class MiniFridgeRecipe
implements Recipe<RecipeInput> {
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final int craftingTime;

    public MiniFridgeRecipe(NonNullList<Ingredient> inputs, ItemStack output, int craftingTime) {
        this.inputs = inputs;
        this.output = output;
        this.craftingTime = craftingTime;
    }

    public boolean matches(RecipeInput recipeInput, Level level) {
        return BeachpartyUtil.matchesRecipe(recipeInput, this.inputs, 1, 1);
    }

    public ItemStack assemble(RecipeInput recipeInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @NotNull
    public ResourceLocation getId() {
        return RecipeTypeRegistry.MINI_FRIDGE_RECIPE_TYPE.getId();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeTypeRegistry.MINI_FRIDGE_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeTypeRegistry.MINI_FRIDGE_RECIPE_TYPE.get();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    public boolean isSpecial() {
        return true;
    }

    public int getCraftingTime() {
        return this.craftingTime;
    }

    public static class Serializer
    implements RecipeSerializer<MiniFridgeRecipe> {
        public static final StreamCodec<RegistryFriendlyByteBuf, MiniFridgeRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);
        public static final MapCodec<MiniFridgeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(list -> {
            Object[] ingredients = (Ingredient[])list.toArray(Ingredient[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredients for Cauldron recipe");
            }
            return ingredients.length > 1 ? DataResult.error(() -> "Too many ingredients for Cauldron recipe") : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(MiniFridgeRecipe::getIngredients), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(miniFridgeRecipe -> miniFridgeRecipe.output), (App)Codec.INT.fieldOf("crafting_time").forGetter(MiniFridgeRecipe::getCraftingTime)).apply((Applicative)instance, MiniFridgeRecipe::new));

        public MapCodec<MiniFridgeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, MiniFridgeRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        @NotNull
        public static MiniFridgeRecipe fromNetwork(RegistryFriendlyByteBuf buf) {
            int i = buf.readVarInt();
            NonNullList nonNullList = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            nonNullList.replaceAll(ingredient -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf));
            ItemStack itemStack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
            int craftingTime = buf.readInt();
            return new MiniFridgeRecipe((NonNullList<Ingredient>)nonNullList, itemStack, craftingTime);
        }

        public static void toNetwork(RegistryFriendlyByteBuf buf, MiniFridgeRecipe recipe) {
            buf.writeVarInt(recipe.inputs.size());
            for (Ingredient ingredient : recipe.getIngredients()) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.output);
            buf.writeInt(recipe.craftingTime);
        }
    }
}

