/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageInABottleItem
extends BlockItem {
    public MessageInABottleItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    @Nullable
    public static ItemStack getRandomMap(Entity entity) {
        int index = entity.level().getRandom().nextInt(4);
        return switch (index) {
            case 0 -> MessageInABottleItem.createMansionMap(entity);
            case 1 -> MessageInABottleItem.createShipwreckMap(entity);
            case 2 -> MessageInABottleItem.createMonumentMap(entity);
            case 3 -> MessageInABottleItem.createTreasureMap(entity);
            default -> null;
        };
    }

    public static ItemStack createMonumentMap(Entity entity) {
        return MessageInABottleItem.createMap(entity, (TagKey<Structure>)StructureTags.ON_OCEAN_EXPLORER_MAPS, "filled_map.monument", (MapDecorationType)MapDecorationTypes.OCEAN_MONUMENT.value());
    }

    public static ItemStack createMansionMap(Entity entity) {
        return MessageInABottleItem.createMap(entity, (TagKey<Structure>)StructureTags.ON_WOODLAND_EXPLORER_MAPS, "filled_map.mansion", (MapDecorationType)MapDecorationTypes.WOODLAND_MANSION.value());
    }

    public static ItemStack createShipwreckMap(Entity entity) {
        return MessageInABottleItem.createMap(entity, (TagKey<Structure>)StructureTags.SHIPWRECK, "filled_map.shipwreck", (MapDecorationType)MapDecorationTypes.RED_X.value());
    }

    public static ItemStack createTreasureMap(Entity entity) {
        return MessageInABottleItem.createMap(entity, (TagKey<Structure>)StructureTags.ON_TREASURE_MAPS, "filled_map.treasure", (MapDecorationType)MapDecorationTypes.RED_X.value());
    }

    @Nullable
    public static ItemStack createMap(Entity entity, TagKey<Structure> structure, String nameKey, MapDecorationType iconType) {
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverWorld = (ServerLevel)level;
        BlockPos pos = serverWorld.findNearestMapStructure(structure, entity.blockPosition(), 100, true);
        if (pos != null) {
            ItemStack stack = MapItem.create((Level)serverWorld, (int)pos.getX(), (int)pos.getZ(), (byte)2, (boolean)true, (boolean)true);
            MapItem.renderBiomePreviewMap((ServerLevel)serverWorld, (ItemStack)stack);
            MapItemSavedData.addTargetDecoration((ItemStack)stack, (BlockPos)pos, (String)"+", (Holder)BuiltInRegistries.MAP_DECORATION_TYPE.wrapAsHolder((Object)iconType));
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)nameKey));
            return stack;
        }
        return null;
    }

    private static void spawnItem(Level world, double x, double y, double z, ItemStack stack) {
        world.addFreshEntity((Entity)new ItemEntity(world, x, y, z, stack));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        if (world.isClientSide()) {
            return InteractionResultHolder.success((Object)user.getItemInHand(hand));
        }
        RandomSource random = world.getRandom();
        int randomNumber = random.nextInt(100);
        ItemStack dropStack = randomNumber < 50 ? new ItemStack((ItemLike)Items.PAPER) : (randomNumber < 80 ? new ItemStack((ItemLike)Items.MAP) : MessageInABottleItem.getRandomMap((Entity)user));
        if (dropStack == null) {
            dropStack = new ItemStack((ItemLike)Items.PAPER);
        }
        double x = user.getX();
        double y = user.getY();
        double z = user.getZ();
        MessageInABottleItem.spawnItem(world, x, y, z, dropStack);
        MessageInABottleItem.spawnItem(world, x, y, z, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
        user.getItemInHand(hand).shrink(1);
        return InteractionResultHolder.success((Object)user.getItemInHand(hand));
    }
}

