/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block.entity;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.beachparty.core.block.BeachGoalBlock;
import net.satisfy.beachparty.core.entity.BeachBallEntity;
import net.satisfy.beachparty.core.registry.EntityTypeRegistry;

public class BeachGoalBlockEntity
extends BlockEntity {
    private static final int PRESENCE_THRESHOLD = 10;
    private boolean hasBeachBall = false;
    private int ballPresenceCounter = 0;
    private static final int[] FW_PALETTE = new int[]{0xFF0000, 16753920, 0xFFFF00, 65280, 65535, 255, 9055202, 0xFF00FF, 0xFFFFFF, 11393254, 16032864, 16744272, 0x7FFF00, 16766720};

    public BeachGoalBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.BEACH_GOAL_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BeachGoalBlockEntity blockEntity) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BeachGoalBlock block = (BeachGoalBlock)state.getBlock();
        VoxelShape detectionShape = block.getDetectionShape(state);
        VoxelShape worldShape = detectionShape.move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        AABB detectionAABB = worldShape.bounds();
        List balls = serverLevel.getEntitiesOfClass(BeachBallEntity.class, detectionAABB.inflate(0.1), Entity::isAlive);
        boolean detected = false;
        for (BeachBallEntity ball : balls) {
            VoxelShape ballShape = Shapes.create((AABB)ball.getBoundingBox());
            if (!Shapes.joinIsNotEmpty((VoxelShape)worldShape, (VoxelShape)ballShape, (BooleanOp)BooleanOp.AND)) continue;
            detected = true;
            break;
        }
        blockEntity.ballPresenceCounter = detected ? Math.min(blockEntity.ballPresenceCounter + 1, 10) : Math.max(blockEntity.ballPresenceCounter - 1, 0);
        boolean previouslyHadBall = blockEntity.hasBeachBall;
        boolean bl = blockEntity.hasBeachBall = blockEntity.ballPresenceCounter >= 10;
        if (blockEntity.hasBeachBall && !previouslyHadBall) {
            blockEntity.fireRockets(serverLevel, pos);
            level.updateNeighborsAt(pos, state.getBlock());
        } else if (!blockEntity.hasBeachBall && previouslyHadBall) {
            level.updateNeighborsAt(pos, state.getBlock());
        }
    }

    public boolean hasBeachBall() {
        return this.hasBeachBall;
    }

    private void fireRockets(ServerLevel world, BlockPos pos) {
        int rocketCount = 3 + world.random.nextInt(3);
        for (int i = 0; i < rocketCount; ++i) {
            double dx = (world.random.nextDouble() - 0.5) * 0.18;
            double dz = (world.random.nextDouble() - 0.5) * 0.18;
            double dy = 1.15 + world.random.nextDouble() * 0.25;
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 2.0;
            double z = (double)pos.getZ() + 0.5;
            int flight = 1 + world.random.nextInt(3);
            int explosions = 1 + world.random.nextInt(3);
            ItemStack fireworkItem = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
            ArrayList<FireworkExplosion> list = new ArrayList<FireworkExplosion>(explosions);
            for (int e = 0; e < explosions; ++e) {
                list.add(this.randomExplosion(world.random));
            }
            fireworkItem.set(DataComponents.FIREWORKS, (Object)new Fireworks(flight, list));
            FireworkRocketEntity rocket = new FireworkRocketEntity((Level)world, fireworkItem, x, y, z, false);
            rocket.setDeltaMovement(dx, dy, dz);
            world.addFreshEntity((Entity)rocket);
        }
    }

    private FireworkExplosion randomExplosion(RandomSource random) {
        FireworkExplosion.Shape[] shapes = FireworkExplosion.Shape.values();
        FireworkExplosion.Shape shape = shapes[random.nextInt(shapes.length)];
        IntList colors = this.randomPaletteColors(random, 1, 4);
        IntList fade = this.randomPaletteColors(random, 0, 3);
        boolean trail = random.nextBoolean();
        boolean twinkle = random.nextBoolean();
        return new FireworkExplosion(shape, colors, fade, trail, twinkle);
    }

    private IntList randomPaletteColors(RandomSource random, int min, int maxInclusive) {
        int n = min + random.nextInt(maxInclusive - min + 1);
        IntArrayList out = new IntArrayList(n);
        for (int i = 0; i < n; ++i) {
            out.add(FW_PALETTE[random.nextInt(FW_PALETTE.length)]);
        }
        return out;
    }

    public void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.putBoolean("HasBeachBall", this.hasBeachBall);
        compoundTag.putInt("BallPresenceCounter", this.ballPresenceCounter);
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.hasBeachBall = compoundTag.getBoolean("HasBeachBall");
        this.ballPresenceCounter = compoundTag.getInt("BallPresenceCounter");
    }
}

