/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;

public class FoodComponent {
    private final int nutrition;
    private final float saturationModifier;
    private final boolean canAlwaysEat;
    private final float eatSeconds;
    private final Optional<ItemStack> usingConvertsTo;
    private final List<FoodProperties.PossibleEffect> effects;
    private final FoodProperties foodProperties;
    public static final Codec<FoodComponent> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("nutrition").forGetter(FoodComponent::nutrition), (App)Codec.FLOAT.fieldOf("saturation").forGetter(FoodComponent::saturationModifier), (App)Codec.BOOL.optionalFieldOf("can_always_eat", (Object)false).forGetter(FoodComponent::canAlwaysEat), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("eat_seconds", (Object)Float.valueOf(1.6f)).forGetter(FoodComponent::eatSeconds), (App)ItemStack.SINGLE_ITEM_CODEC.optionalFieldOf("using_converts_to").forGetter(FoodComponent::usingConvertsTo), (App)FoodProperties.PossibleEffect.CODEC.listOf().optionalFieldOf("effects", List.of()).forGetter(FoodComponent::getEffects)).apply((Applicative)instance, FoodComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FoodComponent> DIRECT_STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, FoodComponent::nutrition, (StreamCodec)ByteBufCodecs.FLOAT, FoodComponent::saturationModifier, (StreamCodec)ByteBufCodecs.BOOL, FoodComponent::canAlwaysEat, (StreamCodec)ByteBufCodecs.FLOAT, FoodComponent::eatSeconds, (StreamCodec)ItemStack.STREAM_CODEC.apply(ByteBufCodecs::optional), FoodComponent::usingConvertsTo, (StreamCodec)FoodProperties.PossibleEffect.STREAM_CODEC.apply(ByteBufCodecs.list()), FoodComponent::getEffects, FoodComponent::new);

    public FoodComponent(int nutrition, float saturationModifier, boolean canAlwaysEat, float eatSeconds, Optional<ItemStack> usingConvertsTo, List<FoodProperties.PossibleEffect> effects) {
        this.nutrition = nutrition;
        this.saturationModifier = saturationModifier;
        this.canAlwaysEat = canAlwaysEat;
        this.eatSeconds = eatSeconds;
        this.usingConvertsTo = usingConvertsTo;
        this.effects = effects;
        FoodProperties.Builder builder = new FoodProperties.Builder().nutrition(nutrition).saturationModifier(saturationModifier);
        if (canAlwaysEat) {
            builder.alwaysEdible();
        }
        for (FoodProperties.PossibleEffect effect : effects) {
            builder.effect(effect.effect(), effect.probability());
        }
        this.foodProperties = builder.build();
    }

    public FoodComponent(List<FoodProperties.PossibleEffect> statusEffects) {
        this(1, 0.0f, true, 1.6f, Optional.empty(), statusEffects);
    }

    public FoodComponent(int nutrition, float saturationModifier, boolean canAlwaysEat, boolean fastFood, boolean meat, List<FoodProperties.PossibleEffect> statusEffects) {
        this.nutrition = nutrition;
        this.saturationModifier = saturationModifier;
        this.canAlwaysEat = canAlwaysEat;
        this.eatSeconds = fastFood ? 0.8f : 1.6f;
        this.usingConvertsTo = Optional.empty();
        this.effects = statusEffects;
        FoodProperties.Builder builder = new FoodProperties.Builder().nutrition(nutrition).saturationModifier(saturationModifier);
        if (canAlwaysEat) {
            builder.alwaysEdible();
        }
        if (fastFood) {
            builder.fast();
        }
        for (FoodProperties.PossibleEffect effect : statusEffects) {
            builder.effect(effect.effect(), effect.probability());
        }
        this.foodProperties = builder.build();
    }

    public List<FoodProperties.PossibleEffect> getEffects() {
        return this.effects;
    }

    public FoodProperties getFoodProperties() {
        return this.foodProperties;
    }

    public int nutrition() {
        return this.nutrition;
    }

    public int getNutrition() {
        return this.nutrition;
    }

    public float saturationModifier() {
        return this.saturationModifier;
    }

    public float getSaturationModifier() {
        return this.saturationModifier;
    }

    public boolean canAlwaysEat() {
        return this.canAlwaysEat;
    }

    public float eatSeconds() {
        return this.eatSeconds;
    }

    public Optional<ItemStack> usingConvertsTo() {
        return this.usingConvertsTo;
    }

    public boolean isFastFood() {
        return this.eatSeconds < 1.6f;
    }
}

