/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.satisfy.vinery.core.recipe.input.FermentationBarrelRecipeInput;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.registry.RecipeTypesRegistry;
import org.jetbrains.annotations.NotNull;

public class FermentationBarrelRecipe
implements Recipe<FermentationBarrelRecipeInput> {
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final FermentationBarrelRecipeInput.JuiceData juiceData;
    private final boolean wineBottleRequired;
    public static RecipeType<FermentationBarrelRecipe> Type = (RecipeType)RecipeTypesRegistry.FERMENTATION_BARREL_RECIPE_TYPE.get();

    public FermentationBarrelRecipe(NonNullList<Ingredient> inputs, FermentationBarrelRecipeInput.JuiceData data, ItemStack output, boolean wineBottleRequired) {
        this.inputs = inputs;
        this.juiceData = data;
        this.output = output;
        this.wineBottleRequired = wineBottleRequired;
    }

    public FermentationBarrelRecipeInput.JuiceData getJuiceData() {
        return this.juiceData;
    }

    public boolean isWineBottleRequired() {
        return this.wineBottleRequired;
    }

    public boolean matches(FermentationBarrelRecipeInput input, Level world) {
        ItemStack wineBottle;
        if (this.juiceData.amount() > 0) {
            if (input.data().amount() < this.juiceData.amount()) {
                return false;
            }
            if (!this.juiceData.type().equals(input.data().type())) {
                return false;
            }
        }
        if (this.wineBottleRequired && ((wineBottle = input.getItem(0)).isEmpty() || !wineBottle.is((Item)ObjectRegistry.WINE_BOTTLE.get()))) {
            return false;
        }
        StackedContents recipeMatcher = new StackedContents();
        int matchingStacks = 0;
        for (int i = 0; i < input.getIngredientSlots().size(); ++i) {
            ItemStack itemStack = input.getIngredientSlots().get(i);
            if (itemStack.isEmpty()) continue;
            ++matchingStacks;
            recipeMatcher.accountStack(itemStack, 1);
        }
        return matchingStacks == this.inputs.size() && recipeMatcher.canCraft((Recipe)this, null);
    }

    @NotNull
    public ItemStack assemble(FermentationBarrelRecipeInput input, HolderLookup.Provider registryAccess) {
        return this.output.copy();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.output.copy();
    }

    public NonNullList<Ingredient> getInputs() {
        return this.inputs;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeTypesRegistry.FERMENTATION_BARREL_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeTypesRegistry.FERMENTATION_BARREL_RECIPE_TYPE.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<FermentationBarrelRecipe> {
        private static final MapCodec<Boolean> WINE_BOTTLE_CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.BOOL.fieldOf("required").forGetter(b -> b)).apply((Applicative)inst, b -> b));

        public MapCodec<FermentationBarrelRecipe> codec() {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.listOf().fieldOf("ingredients").xmap(list -> NonNullList.of((Object)Ingredient.EMPTY, (Object[])list.toArray(new Ingredient[0])), ingredients -> ingredients).forGetter(FermentationBarrelRecipe::getInputs), (App)FermentationBarrelRecipeInput.JuiceData.CODEC.fieldOf("juice").forGetter(FermentationBarrelRecipe::getJuiceData), (App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.output), (App)WINE_BOTTLE_CODEC.fieldOf("wine_bottle").forGetter(FermentationBarrelRecipe::isWineBottleRequired)).apply((Applicative)instance, FermentationBarrelRecipe::new));
        }

        public StreamCodec<RegistryFriendlyByteBuf, FermentationBarrelRecipe> streamCodec() {
            return StreamCodec.of((buf, recipe) -> {
                buf.writeVarInt(recipe.inputs.size());
                for (Ingredient ingredient : recipe.inputs) {
                    Ingredient.CONTENTS_STREAM_CODEC.encode(buf, (Object)ingredient);
                }
                FermentationBarrelRecipeInput.JuiceData.STREAM_CODEC.encode(buf, (Object)recipe.getJuiceData());
                ItemStack.STREAM_CODEC.encode(buf, (Object)recipe.output);
                buf.writeBoolean(recipe.wineBottleRequired);
            }, buf -> {
                int size = buf.readVarInt();
                NonNullList inputs = NonNullList.withSize((int)size, (Object)Ingredient.EMPTY);
                for (int i = 0; i < size; ++i) {
                    inputs.set(i, (Object)((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode(buf)));
                }
                FermentationBarrelRecipeInput.JuiceData juiceData = (FermentationBarrelRecipeInput.JuiceData)FermentationBarrelRecipeInput.JuiceData.STREAM_CODEC.decode(buf);
                ItemStack output = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
                boolean wineBottleRequired = buf.readBoolean();
                return new FermentationBarrelRecipe((NonNullList<Ingredient>)inputs, juiceData, output, wineBottleRequired);
            });
        }
    }
}

