/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.satisfy.vinery.core.recipe.input.ApplePressFermentingRecipeInput;
import net.satisfy.vinery.core.registry.RecipeTypesRegistry;
import org.jetbrains.annotations.NotNull;

public class ApplePressFermentingRecipe
implements Recipe<ApplePressFermentingRecipeInput> {
    public final Ingredient input;
    private final ItemStack output;
    private final boolean requiresBottle;
    public static RecipeType<ApplePressFermentingRecipe> Type = (RecipeType)RecipeTypesRegistry.APPLE_PRESS_FERMENTING_RECIPE_TYPE.get();

    public ApplePressFermentingRecipe(Ingredient input, ItemStack output, boolean requiresBottle) {
        this.input = input;
        this.output = output;
        this.requiresBottle = requiresBottle;
    }

    public boolean requiresBottle() {
        return this.requiresBottle;
    }

    public boolean matches(ApplePressFermentingRecipeInput inventory, Level world) {
        return this.input.test(inventory.getItem(0));
    }

    @NotNull
    public ItemStack assemble(ApplePressFermentingRecipeInput container, HolderLookup.Provider registryAccess) {
        return this.output.copy();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList list = NonNullList.create();
        list.add((Object)this.input);
        return list;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider registryAccess) {
        return this.output.copy();
    }

    public Ingredient getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public boolean isRequiresBottle() {
        return this.requiresBottle;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeTypesRegistry.APPLE_PRESS_FERMENTING_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeTypesRegistry.APPLE_PRESS_FERMENTING_RECIPE_TYPE.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<ApplePressFermentingRecipe> {
        private static final MapCodec<Boolean> WINE_BOTTLE_CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)Codec.BOOL.fieldOf("required").forGetter(b -> b)).apply((Applicative)inst, b -> b));

        public MapCodec<ApplePressFermentingRecipe> codec() {
            return RecordCodecBuilder.mapCodec(inst -> inst.group((App)Ingredient.CODEC.fieldOf("input").forGetter(ApplePressFermentingRecipe::getInput), (App)ItemStack.CODEC.fieldOf("output").forGetter(ApplePressFermentingRecipe::getOutput), (App)WINE_BOTTLE_CODEC.fieldOf("wine_bottle").forGetter(ApplePressFermentingRecipe::isRequiresBottle)).apply((Applicative)inst, ApplePressFermentingRecipe::new));
        }

        public StreamCodec<RegistryFriendlyByteBuf, ApplePressFermentingRecipe> streamCodec() {
            return new StreamCodec<RegistryFriendlyByteBuf, ApplePressFermentingRecipe>(this){

                public ApplePressFermentingRecipe decode(RegistryFriendlyByteBuf buf) {
                    return new ApplePressFermentingRecipe((Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buf), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf), buf.readBoolean());
                }

                public void encode(RegistryFriendlyByteBuf buf, ApplePressFermentingRecipe recipe) {
                    Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buf, (Object)recipe.getInput());
                    ItemStack.STREAM_CODEC.encode((Object)buf, (Object)recipe.getOutput());
                    buf.writeBoolean(recipe.isRequiresBottle());
                }
            };
        }
    }
}

