/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.mixin;

import com.mojang.authlib.GameProfile;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={LocalPlayer.class})
public abstract class ClientPlayerEntityMixin
extends AbstractClientPlayer {
    @Unique
    private int jumpCount = 0;
    @Unique
    private boolean jumpedLastTick = false;

    public ClientPlayerEntityMixin(ClientLevel clientLevel, GameProfile gameProfile) {
        super(clientLevel, gameProfile);
    }

    @Unique
    private boolean wearingUsableElytra(LocalPlayer player) {
        ItemStack chestItemStack = player.getItemBySlot(EquipmentSlot.CHEST);
        return chestItemStack.getItem() == Items.ELYTRA && ElytraItem.isFlyEnabled((ItemStack)chestItemStack);
    }

    @Unique
    private boolean canJump(LocalPlayer player) {
        return !this.wearingUsableElytra(player) && !player.isFallFlying() && !player.isPassenger() && !player.isInWater() && !player.hasEffect(MobEffects.LEVITATION);
    }
}

