/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.item;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.vinery.core.block.entity.StorageBlockEntity;
import net.satisfy.vinery.core.registry.DataComponentRegistry;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.util.GeneralUtil;
import net.satisfy.vinery.core.util.WineYears;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrinkBlockItem
extends BlockItem {
    private int baseDuration = 0;
    private boolean scaleDurationWithAge;
    private final BottleSize bottleSize;
    private Supplier<Holder<MobEffect>> effectSupplier;
    private int baseAmplifier;

    public DrinkBlockItem(Block block, Item.Properties settings, boolean scaleDurationWithAge, BottleSize bottleSize) {
        super(block, settings);
        this.scaleDurationWithAge = scaleDurationWithAge;
        this.bottleSize = bottleSize;
        this.effectSupplier = null;
        this.baseAmplifier = 0;
    }

    public void setEffectSupplier(Supplier<Holder<MobEffect>> effectSupplier, int baseDuration, int baseAmplifier) {
        this.effectSupplier = effectSupplier;
        this.baseDuration = baseDuration;
        this.baseAmplifier = baseAmplifier;
    }

    @NotNull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.DRINK;
    }

    protected BlockState getPlacementState(BlockPlaceContext context) {
        if (!Objects.requireNonNull(context.getPlayer()).isCrouching()) {
            return null;
        }
        BlockState blockState = this.getBlock().getStateForPlacement(context);
        return blockState != null && this.canPlace(context, blockState) ? blockState : null;
    }

    protected boolean updateCustomBlockEntityTag(BlockPos blockPos, Level level, @Nullable Player player, ItemStack itemStack, BlockState blockState) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof StorageBlockEntity) {
            StorageBlockEntity wineEntity = (StorageBlockEntity)blockEntity;
            wineEntity.setStack(0, itemStack.copyWithCount(1));
        }
        return super.updateCustomBlockEntityTag(blockPos, level, player, itemStack, blockState);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        Level world = null;
        if (tooltipContext.registries() != null) {
            world = this.getLevel();
        }
        if (this.effectSupplier != null && world != null) {
            Holder<MobEffect> effectHolder = this.effectSupplier.get();
            MobEffect effect = (MobEffect)effectHolder.value();
            String effectName = effect.getDisplayName().getString();
            int amplifier = Math.max(0, WineYears.getEffectLevel(stack, world));
            String amplifierRoman = amplifier > 0 ? " " + this.toRoman(amplifier) : "";
            int durationTicks = this.scaleDurationWithAge ? WineYears.getEffectDuration(stack, world) : this.baseDuration;
            durationTicks = Math.max(0, durationTicks);
            String formattedDuration = this.formatDuration(durationTicks);
            String tooltipText = effectName + amplifierRoman + " (" + formattedDuration + ")";
            tooltip.add((Component)Component.literal((String)tooltipText).withStyle(effect.getCategory().getTooltipFormatting()));
        } else {
            tooltip.add((Component)Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY));
        }
        tooltip.add((Component)Component.empty());
        if (world != null) {
            int age = Math.max(0, WineYears.getWineAge(stack, world));
            int ageDays = WineYears.getWineAgeDays(stack, world);
            tooltip.add((Component)Component.translatable((String)"tooltip.vinery.age", (Object[])new Object[]{age}).withStyle(ChatFormatting.WHITE));
            tooltip.add((Component)Component.empty());
            int daysToNextUpgrade = WineYears.YEARS_PER_EFFECT_LEVEL * WineYears.DAYS_PER_YEAR - ageDays % (WineYears.YEARS_PER_EFFECT_LEVEL * WineYears.DAYS_PER_YEAR);
            tooltip.add((Component)Component.translatable((String)"tooltip.vinery.next_upgrade", (Object[])new Object[]{daysToNextUpgrade}).withStyle(style -> style.withColor(TextColor.fromRgb((int)9684093))));
        }
        tooltip.add((Component)Component.translatable((String)("tooltip.vinery.bottle_size." + this.bottleSize.name().toLowerCase())).withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
    }

    @OnlyIn(value=Dist.CLIENT)
    private Level getLevel() {
        return Minecraft.getInstance().level;
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity livingEntity) {
        if (!level.isClientSide && this.effectSupplier != null) {
            int duration = this.scaleDurationWithAge ? Math.max(0, WineYears.getEffectDuration(itemStack, level)) : this.baseDuration;
            int amplifier = this.scaleDurationWithAge ? Math.max(0, WineYears.getEffectLevel(itemStack, level)) : this.baseAmplifier;
            Holder<MobEffect> effectHolder = this.effectSupplier.get();
            MobEffect effect = (MobEffect)effectHolder.value();
            Holder registryHolder = level.registryAccess().registryOrThrow(Registries.MOB_EFFECT).wrapAsHolder((Object)effect);
            livingEntity.addEffect(new MobEffectInstance(registryHolder, duration, amplifier));
        }
        itemStack.shrink(1);
        return GeneralUtil.convertStackAfterFinishUsing(livingEntity, itemStack, (Item)ObjectRegistry.WINE_BOTTLE.get(), (Item)this);
    }

    private String formatDuration(int ticks) {
        int totalSeconds = Math.max(0, ticks) / 20;
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        return String.format("%d:%02d", minutes, seconds);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)interactionHand);
    }

    public void onCraftedBy(ItemStack stack, Level world, Player player) {
        super.onCraftedBy(stack, world, player);
        WineYears.setWineYear(stack, world);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(stack, world, entity, slot, selected);
        if (world != null && !world.isClientSide) {
            if (stack.get((DataComponentType)DataComponentRegistry.WINE_YEAR.get()) == null) {
                WineYears.setWineYear(stack, world);
            } else if (world.getGameTime() % 200L == 0L) {
                WineYears.refreshCached(stack, world);
            }
        }
    }

    private String toRoman(int number) {
        return switch (number) {
            case 1 -> "I";
            case 2 -> "II";
            case 3 -> "III";
            case 4 -> "IV";
            case 5 -> "V";
            case 6 -> "VI";
            case 7 -> "VII";
            case 8 -> "VIII";
            case 9 -> "IX";
            case 10 -> "X";
            default -> String.valueOf(number);
        };
    }

    public static enum BottleSize {
        SMALL,
        BIG;

    }
}

