/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.effect;

import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class ClimbingEffect
extends MobEffect {
    public ClimbingEffect() {
        super(MobEffectCategory.BENEFICIAL, 0xCC3300);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        if (entity.horizontalCollision) {
            entity.fallDistance = 0.0f;
            float velocity = 0.15f;
            Vec3 motion = entity.getDeltaMovement();
            double motionX = Mth.clamp((double)motion.x, (double)-0.15f, (double)0.15f);
            double motionY = 0.2;
            double motionZ = Mth.clamp((double)motion.z, (double)-0.15f, (double)0.15f);
            if (entity.isSuppressingSlidingDownLadder()) {
                motionY = 0.0;
            }
            entity.setDeltaMovement(motionX, motionY, motionZ);
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int i, int j) {
        return true;
    }
}

