/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.satisfy.vinery.core.block.state.properties.GrapeProperty;
import net.satisfy.vinery.core.registry.GrapeTypeRegistry;
import net.satisfy.vinery.core.util.GeneralUtil;
import net.satisfy.vinery.core.util.GrapeType;
import org.jetbrains.annotations.NotNull;

public abstract class StemBlock
extends Block
implements BonemealableBlock {
    public static final GrapeProperty GRAPE = GrapeProperty.create("grape");
    public static final IntegerProperty AGE = BlockStateProperties.AGE_4;

    public void dropGrapes(Level world, BlockState state, BlockPos pos, Direction direction) {
        int x = 1 + world.random.nextInt(this.isMature(state) ? 2 : 1);
        int bonus = this.isMature(state) ? 2 : 1;
        Item grape = ((GrapeType)state.getValue((Property)GRAPE)).getFruit();
        ItemStack stack = new ItemStack((ItemLike)grape, x + bonus);
        if (direction == null) {
            StemBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)stack);
        } else {
            GeneralUtil.popResourceFromFace(world, pos, direction, stack);
        }
        world.playSound(null, pos, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + world.random.nextFloat() * 0.4f);
    }

    public void dropGrapeSeeds(Level world, BlockState state, BlockPos pos, Direction direction) {
        Item grape = ((GrapeType)state.getValue((Property)GRAPE)).getSeeds();
        ItemStack stack = new ItemStack((ItemLike)grape);
        if (direction == null) {
            StemBlock.popResource((Level)world, (BlockPos)pos, (ItemStack)stack);
        } else {
            GeneralUtil.popResourceFromFace(world, pos, direction, stack);
        }
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        int age = (Integer)state.getValue((Property)AGE);
        if (age > 3) {
            this.dropGrapes(world, state, pos, hit.getDirection());
            world.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(2)), 2);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        if ((Integer)state.getValue((Property)AGE) > 2) {
            this.dropGrapes(world, state, pos, null);
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public boolean hasTrunk(Level world, BlockPos pos) {
        return world.getBlockState(pos.below()).getBlock() == this;
    }

    private void boneMealGrow(Level world, BlockState state, BlockPos pos) {
        int age = (Integer)state.getValue((Property)AGE) + Mth.nextInt((RandomSource)world.getRandom(), (int)1, (int)2);
        int j = 4;
        if (age > 4) {
            age = j;
        }
        world.setBlock(pos, this.withAge(state, age, (GrapeType)state.getValue((Property)GRAPE)), 2);
    }

    public StemBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)GRAPE, (Comparable)GrapeTypeRegistry.NONE)).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, GRAPE});
    }

    public boolean isMature(BlockState state) {
        return (Integer)state.getValue((Property)AGE) >= 4;
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState state) {
        return !this.isMature(state) && levelReader.getBlockState(blockPos.below()).getBlock() == this && (Integer)state.getValue((Property)AGE) > 0;
    }

    public boolean isBonemealSuccess(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        this.boneMealGrow((Level)world, state, pos);
    }

    public BlockState withAge(BlockState state, int age, GrapeType type) {
        return (BlockState)((BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age))).setValue((Property)GRAPE, (Comparable)type);
    }
}

