/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.vinery.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackableLogBlock
extends SlabBlock {
    public static final BooleanProperty FIRED = BooleanProperty.create((String)"fired");
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final Supplier<VoxelShape> BOTTOM_AABB_SUPPLIER = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0, (double)0.3125, (double)0.25, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.25, (double)0.6875, (double)1.0, (double)0.5, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.0, (double)0.0, (double)0.9375, (double)0.25, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.25, (double)0.0625, (double)1.0, (double)0.5, (double)0.3125), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    private static final Supplier<VoxelShape> TOP_AABB_SUPPLIER = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.5, (double)0.0, (double)0.3125, (double)0.75, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.75, (double)0.6875, (double)1.0, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.5, (double)0.0, (double)0.9375, (double)0.75, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.75, (double)0.0625, (double)1.0, (double)1.0, (double)0.3125), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    private static final Supplier<VoxelShape> DOUBLE_SUPPLIER = () -> {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.0, (double)0.0, (double)0.3125, (double)0.25, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0625, (double)0.5, (double)0.0, (double)0.3125, (double)0.75, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.25, (double)0.6875, (double)1.0, (double)0.5, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.75, (double)0.6875, (double)1.0, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.0, (double)0.0, (double)0.9375, (double)0.25, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.6875, (double)0.5, (double)0.0, (double)0.9375, (double)0.75, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.25, (double)0.0625, (double)1.0, (double)0.5, (double)0.3125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.joinUnoptimized((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.75, (double)0.0625, (double)1.0, (double)1.0, (double)0.3125), (BooleanOp)BooleanOp.OR);
        return shape;
    };
    protected static final VoxelShape BOTTOM_AABB = BOTTOM_AABB_SUPPLIER.get();
    protected static final VoxelShape TOP_AABB = TOP_AABB_SUPPLIER.get();
    protected static final VoxelShape DOUBLE = DOUBLE_SUPPLIER.get();
    public static final Map<Direction, Map<SlabType, VoxelShape>> SHAPE = (Map)Util.make(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.stream().toList()) {
            map.put(direction, new HashMap());
            ((Map)map.get(direction)).put(SlabType.DOUBLE, GeneralUtil.rotateShape(Direction.NORTH, direction, DOUBLE_SUPPLIER.get()));
            ((Map)map.get(direction)).put(SlabType.TOP, GeneralUtil.rotateShape(Direction.NORTH, direction, TOP_AABB_SUPPLIER.get()));
            ((Map)map.get(direction)).put(SlabType.BOTTOM, GeneralUtil.rotateShape(Direction.NORTH, direction, BOTTOM_AABB_SUPPLIER.get()));
        }
    });

    public StackableLogBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)FIRED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        SlabType stackSize = (SlabType)state.getValue((Property)TYPE);
        if (stack.is(Items.FLINT_AND_STEEL) && stackSize == SlabType.DOUBLE) {
            world.setBlock(pos, (BlockState)state.setValue((Property)FIRED, (Comparable)Boolean.valueOf(true)), 3);
            world.playSound(player, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.getItem() instanceof ShovelItem && stackSize == SlabType.DOUBLE && ((Boolean)state.getValue((Property)FIRED)).booleanValue()) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FIRED, (Comparable)Boolean.valueOf(false)));
            world.playSound(player, pos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 1.0f, 1.0f);
            boolean clientSide = world.isClientSide();
            if (clientSide) {
                for (int i = 0; i < 20; ++i) {
                    CampfireBlock.makeParticles((Level)world, (BlockPos)pos, (boolean)false, (boolean)false);
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)clientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.getClickedPos();
        BlockState blockState = ctx.getLevel().getBlockState(blockPos);
        if (blockState.is((Block)this)) {
            return (BlockState)((BlockState)((BlockState)((BlockState)blockState.setValue((Property)TYPE, (Comparable)SlabType.DOUBLE)).setValue((Property)FIRED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
        }
        FluidState fluidState = ctx.getLevel().getFluidState(blockPos);
        BlockState blockState2 = (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TYPE, (Comparable)SlabType.BOTTOM)).setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        Direction direction = ctx.getClickedFace();
        return !(direction == Direction.DOWN || direction != Direction.UP && ctx.getClickLocation().y() - (double)blockPos.getY() > 0.5) ? blockState2 : (BlockState)blockState2.setValue((Property)TYPE, (Comparable)SlabType.TOP);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FIRED, FACING});
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)FIRED)).booleanValue()) {
            StackableLogBlock.displayTickLikeCampfire(world, pos, random, world.getBlockState(pos.below()).is(Blocks.HAY_BLOCK));
        }
    }

    public static void displayTickLikeCampfire(Level world, BlockPos pos, RandomSource random, boolean isSignal) {
        int i;
        if (random.nextFloat() < 0.8f) {
            for (i = 0; i < random.nextInt(5) + 3; ++i) {
                CampfireBlock.makeParticles((Level)world, (BlockPos)pos, (boolean)isSignal, (boolean)true);
            }
        }
        if (random.nextInt(10) == 0) {
            world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
        }
        if (random.nextInt(5) == 0) {
            for (i = 0; i < random.nextInt(4) + 3; ++i) {
                world.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, (double)(random.nextFloat() / 2.0f), 5.0E-5, (double)(random.nextFloat() / 2.0f));
            }
        }
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        boolean isLit = (Boolean)world.getBlockState(pos).getValue((Property)FIRED);
        if (isLit && !entity.fireImmune() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            Holder.Reference frostWalker = livingEntity.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FROST_WALKER);
            if (livingEntity.getItemBySlot(EquipmentSlot.FEET).getEnchantments().getLevel((Holder)frostWalker) < 0) {
                entity.hurt(world.damageSources().inFire(), 1.0f);
            }
        }
        super.stepOn(world, pos, state, entity);
    }

    @NotNull
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        SlabType slabType = (SlabType)blockState.getValue((Property)TYPE);
        Direction facing = (Direction)blockState.getValue((Property)FACING);
        return switch (slabType) {
            case SlabType.DOUBLE -> SHAPE.get(facing).get(SlabType.DOUBLE);
            case SlabType.TOP -> SHAPE.get(facing).get(SlabType.TOP);
            default -> SHAPE.get(facing).get(SlabType.BOTTOM);
        };
    }
}

