/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.vinery.core.block.StemBlock;
import net.satisfy.vinery.core.item.GrapeBushSeedItem;
import net.satisfy.vinery.core.registry.GrapeTypeRegistry;
import net.satisfy.vinery.core.registry.ObjectRegistry;
import net.satisfy.vinery.core.util.GrapeType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;

public class PaleStemBlock
extends StemBlock {
    private static final VoxelShape PALE_SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final BooleanProperty LEAVES_PENDING = BooleanProperty.create((String)"leaves_pending");
    public static final BooleanProperty LEAVES_DONE = BooleanProperty.create((String)"leaves_done");

    public PaleStemBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)GRAPE, (Comparable)GrapeTypeRegistry.NONE)).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)LEAVES_PENDING, (Comparable)Boolean.valueOf(false))).setValue((Property)LEAVES_DONE, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return PALE_SHAPE;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        BlockState blockState = this.defaultBlockState();
        if (blockState.canSurvive((LevelReader)ctx.getLevel(), ctx.getClickedPos())) {
            return blockState;
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (itemStack != null && (player.isCreative() || itemStack.getCount() >= 2) && level.getBlockState(blockPos.below()).getBlock() != this && blockPos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(blockPos.above()).canBeReplaced()) {
                level.setBlock(blockPos.above(), this.defaultBlockState(), 3);
                itemStack.shrink(1);
            }
        }
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hand == InteractionHand.OFF_HAND) {
            return super.useItemOn(stack, state, world, pos, player, hand, hit);
        }
        int age = (Integer)state.getValue((Property)AGE);
        if (age > 0 && player.getItemInHand(hand).getItem() == Items.SHEARS) {
            if (age > 2) {
                this.dropGrapes(world, state, pos, hit.getDirection());
            }
            this.dropGrapeSeeds(world, state, pos, hit.getDirection());
            world.setBlock(pos, this.withAge(state, Math.max(0, age - 1), (GrapeType)state.getValue((Property)GRAPE)), 3);
            world.playSound(player, pos, SoundEvents.SWEET_BERRY_BUSH_BREAK, SoundSource.AMBIENT, 1.0f, 1.0f);
            return ItemInteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        Item item = stack.getItem();
        if (item instanceof GrapeBushSeedItem) {
            GrapeBushSeedItem seed = (GrapeBushSeedItem)item;
            if (this.hasTrunk(world, pos) && age == 0 && !seed.getType().isLattice()) {
                boolean schedule = seed.getType() == GrapeTypeRegistry.WHITE || seed.getType() == GrapeTypeRegistry.RED;
                BlockState ns = this.withAge(state, 1, seed.getType());
                if (schedule && !((Boolean)state.getValue((Property)LEAVES_PENDING)).booleanValue() && !((Boolean)state.getValue((Property)LEAVES_DONE)).booleanValue()) {
                    ns = (BlockState)ns.setValue((Property)LEAVES_PENDING, (Comparable)Boolean.valueOf(true));
                    int delay = 4800 + world.random.nextInt(4801);
                    world.scheduleTick(pos, (Block)this, delay);
                }
                world.setBlock(pos, ns, 3);
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                world.playSound(player, pos, SoundEvents.SWEET_BERRY_BUSH_PLACE, SoundSource.AMBIENT, 1.0f, 1.0f);
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, world, pos, player, hand, hit);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moved) {
        super.onPlace(state, world, pos, oldState, moved);
        if (!(world.isClientSide || state.getValue((Property)GRAPE) != GrapeTypeRegistry.WHITE && state.getValue((Property)GRAPE) != GrapeTypeRegistry.RED || ((Boolean)state.getValue((Property)LEAVES_PENDING)).booleanValue() || ((Boolean)state.getValue((Property)LEAVES_DONE)).booleanValue())) {
            world.setBlock(pos, (BlockState)state.setValue((Property)LEAVES_PENDING, (Comparable)Boolean.valueOf(true)), 3);
            int delay = 4800 + world.random.nextInt(4801);
            world.scheduleTick(pos, (Block)this, delay);
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            if ((Integer)state.getValue((Property)AGE) > 0) {
                this.dropGrapeSeeds((Level)world, state, pos, null);
            }
            if ((Integer)state.getValue((Property)AGE) > 2) {
                this.dropGrapes((Level)world, state, pos, null);
            }
            world.destroyBlock(pos, true);
            return;
        }
        if (((Boolean)state.getValue((Property)LEAVES_PENDING)).booleanValue()) {
            boolean isRed;
            boolean isWhite = state.getValue((Property)GRAPE) == GrapeTypeRegistry.WHITE;
            boolean bl = isRed = state.getValue((Property)GRAPE) == GrapeTypeRegistry.RED;
            if (isWhite || isRed) {
                List<Vector3i> offsets = Arrays.asList(new Vector3i(-2, 0, -1), new Vector3i(-1, 0, -2), new Vector3i(1, 0, -2), new Vector3i(2, 0, -1), new Vector3i(-2, 0, 1), new Vector3i(-1, 0, 0), new Vector3i(1, 0, 0), new Vector3i(2, 0, 1), new Vector3i(-1, 0, 2), new Vector3i(0, 0, 1), new Vector3i(1, 0, 2));
                for (Vector3i v : offsets) {
                    if (random.nextFloat() > 0.4f) continue;
                    BlockPos ground = pos.offset(v.x, 0, v.z);
                    while (world.isInWorldBounds(ground) && world.getBlockState(ground).isAir()) {
                        ground = ground.below();
                    }
                    BlockPos placePos = ground.above();
                    if (!world.getBlockState(placePos).canBeReplaced()) continue;
                    world.setBlock(placePos, (BlockState)((Block)ObjectRegistry.GRAPEVINE_LEAVES.get()).defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.valueOf(true)), 3);
                }
            }
            world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)LEAVES_PENDING, (Comparable)Boolean.valueOf(false))).setValue((Property)LEAVES_DONE, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        int i;
        Random rand = new Random();
        if (rand.nextInt(100) >= 98) {
            return;
        }
        if (!this.isMature(state) && this.hasTrunk((Level)world, pos) && (Integer)state.getValue((Property)AGE) > 0 && world.getRawBrightness(pos, 0) >= 9 && (i = ((Integer)state.getValue((Property)AGE)).intValue()) < 4) {
            world.setBlock(pos, this.withAge(state, i + 1, (GrapeType)state.getValue((Property)GRAPE)), 2);
        }
        super.randomTick(state, world, pos, random);
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return world.getBlockState(pos.below()).isRedstoneConductor((BlockGetter)world, pos) || world.getBlockState(pos.below()).getBlock() == this;
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.scheduleTick(pos, (Block)this, 1);
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{LEAVES_PENDING, LEAVES_DONE});
    }
}

