/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.satisfy.vinery.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppleLeavesBlock
extends LeavesBlock
implements BonemealableBlock {
    public static final BooleanProperty CAN_GROW_APPLES = BooleanProperty.create((String)"can_grow_apples");
    public static final BooleanProperty HAS_APPLES = BooleanProperty.create((String)"has_apples");
    public static final IntegerProperty AGE = IntegerProperty.create((String)"age", (int)0, (int)3);

    public AppleLeavesBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true))).setValue((Property)DISTANCE, (Comparable)Integer.valueOf(7))).setValue((Property)CAN_GROW_APPLES, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_APPLES, (Comparable)Boolean.valueOf(false))).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (((Boolean)state.getValue((Property)HAS_APPLES)).booleanValue() && (Integer)state.getValue((Property)AGE) == 3) {
            if (!world.isClientSide()) {
                int dropCount = world.getRandom().nextBoolean() ? world.getRandom().nextInt(1, 4) : 1;
                ItemStack dropStack = new ItemStack((ItemLike)Items.APPLE, dropCount);
                AppleLeavesBlock.popResourceFromFace((Level)world, (BlockPos)pos, (Direction)hit.getDirection(), (ItemStack)dropStack);
                world.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)HAS_APPLES, (Comparable)Boolean.valueOf(false))).setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, world, pos, player, hit);
    }

    public boolean isRandomlyTicking(BlockState state) {
        boolean can = (Boolean)state.getValue((Property)CAN_GROW_APPLES);
        boolean has = (Boolean)state.getValue((Property)HAS_APPLES);
        int age = (Integer)state.getValue((Property)AGE);
        return can && !has && age < 2 || has && age == 2 || super.isRandomlyTicking(state);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        boolean canGrowApples = ctx.getLevel().random.nextFloat() < 0.3f;
        return this.updateDistance((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)PERSISTENT, (Comparable)Boolean.valueOf(true))).setValue((Property)CAN_GROW_APPLES, (Comparable)Boolean.valueOf(canGrowApples))).setValue((Property)AGE, (Comparable)Integer.valueOf(0))).setValue((Property)HAS_APPLES, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)), (LevelAccessor)ctx.getLevel(), ctx.getClickedPos());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CAN_GROW_APPLES, HAS_APPLES, AGE});
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.randomTick(state, world, pos, random);
        boolean can = (Boolean)state.getValue((Property)CAN_GROW_APPLES);
        boolean has = (Boolean)state.getValue((Property)HAS_APPLES);
        int age = (Integer)state.getValue((Property)AGE);
        double chance = PlatformHelper.getAppleGrowthChance();
        if (can && !has && age < 2 && random.nextDouble() < chance && this.canGrowPlace((LevelReader)world, pos)) {
            BlockState newState = age == 0 ? (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1)) : (BlockState)((BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(2))).setValue((Property)HAS_APPLES, (Comparable)Boolean.valueOf(true));
            world.setBlock(pos, newState, 2);
            world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newState));
        } else if (has && age == 2 && random.nextDouble() < chance && this.canGrowPlace((LevelReader)world, pos)) {
            BlockState newState = (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(3));
            world.setBlock(pos, newState, 2);
            world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newState));
        }
    }

    private boolean canGrowPlace(LevelReader world, BlockPos pos) {
        return world.getRawBrightness(pos, 0) > 9;
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState state) {
        int age = (Integer)state.getValue((Property)AGE);
        boolean has = (Boolean)state.getValue((Property)HAS_APPLES);
        return age < 2 && !has || age == 2 && has;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockState s = state;
        if (!((Boolean)s.getValue((Property)CAN_GROW_APPLES)).booleanValue()) {
            s = (BlockState)s.setValue((Property)CAN_GROW_APPLES, (Comparable)Boolean.valueOf(true));
        }
        int age = (Integer)s.getValue((Property)AGE);
        boolean has = (Boolean)s.getValue((Property)HAS_APPLES);
        if (!has && age < 2 && this.canGrowPlace((LevelReader)level, pos)) {
            BlockState newState = age == 0 ? (BlockState)s.setValue((Property)AGE, (Comparable)Integer.valueOf(1)) : (BlockState)((BlockState)s.setValue((Property)AGE, (Comparable)Integer.valueOf(2))).setValue((Property)HAS_APPLES, (Comparable)Boolean.valueOf(true));
            level.setBlock(pos, newState, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newState));
        } else if (has && age == 2 && this.canGrowPlace((LevelReader)level, pos)) {
            BlockState newState = (BlockState)s.setValue((Property)AGE, (Comparable)Integer.valueOf(3));
            level.setBlock(pos, newState, 2);
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)newState));
        }
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return this.updateDistance(state, world, pos);
    }

    private static int getDistanceAt(BlockState neighborState) {
        return neighborState.getBlock() instanceof LeavesBlock ? (Integer)neighborState.getValue((Property)DISTANCE) : (neighborState.is(BlockTags.LOGS) ? 0 : 7);
    }

    private BlockState updateDistance(BlockState state, LevelAccessor world, BlockPos pos) {
        Direction dir;
        BlockState neighbor;
        int minDistance = 7;
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        for (int i = 0; i < n && (minDistance = Math.min(minDistance, AppleLeavesBlock.getDistanceAt(neighbor = world.getBlockState(pos.relative(dir = directionArray[i]))) + 1)) != 1; ++i) {
        }
        return (BlockState)state.setValue((Property)DISTANCE, (Comparable)Integer.valueOf(minDistance));
    }

    public int getLightBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return 1;
    }
}

