/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.vinery.client.gui.handler.ApplePressGuiHandler;
import net.satisfy.vinery.core.Vinery;

@OnlyIn(value=Dist.CLIENT)
public class ApplePressGui
extends AbstractContainerScreen<ApplePressGuiHandler> {
    public static final ResourceLocation TEXTURE = Vinery.identifier("textures/gui/apple_press_gui.png");
    public static final int MASHING_BAR_X = 40;
    public static final int MASHING_BAR_Y = 17;
    public static final int MASHING_BAR_WIDTH = 24;
    public static final int MASHING_BAR_HEIGHT = 38;
    public static final int MASHING_BAR_U = 176;
    public static final int MASHING_BAR_V = 0;
    public static final int FERMENTING_BAR_X = 101;
    public static final int FERMENTING_BAR_Y = 18;
    public static final int FERMENTING_BAR_WIDTH = 10;
    public static final int FERMENTING_BAR_HEIGHT = 28;
    public static final int FERMENTING_BAR_U = 176;
    public static final int FERMENTING_BAR_V = 47;

    public ApplePressGui(ApplePressGuiHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
    }

    protected void init() {
        super.init();
    }

    protected void renderBg(GuiGraphics guiGraphics, float f, int i, int j) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        this.renderProgressArrows(guiGraphics, x, y);
    }

    private void renderProgressArrows(GuiGraphics guiGraphics, int x, int y) {
        int yPosition;
        int xPosition;
        int height;
        if (((ApplePressGuiHandler)this.menu).isCrafting(0)) {
            height = ((ApplePressGuiHandler)this.menu).getScaledProgress(0);
            xPosition = x + 40;
            yPosition = y + 17 + height;
            int textureV = 0 + height;
            int renderHeight = 38 - height;
            guiGraphics.blit(TEXTURE, xPosition, yPosition, 176, textureV, 24, renderHeight);
        }
        if (((ApplePressGuiHandler)this.menu).isCrafting(1)) {
            height = ((ApplePressGuiHandler)this.menu).getScaledProgress(1);
            xPosition = x + 101;
            yPosition = y + 18 + 28 - height;
            guiGraphics.blit(TEXTURE, xPosition, yPosition, 176, 75 - height, 10, height);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }
}

