/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.platform.neoforge;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.LoadingModList;
import net.neoforged.fml.loading.moddiscovery.ModInfo;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.satisfy.meadow.neoforge.core.config.MeadowNeoForgeConfig;
import org.jetbrains.annotations.Nullable;

public class PlatformHelperImpl {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"meadow");

    public static <T extends Entity> Supplier<EntityType<T>> registerBoatType(String name, EntityType.EntityFactory<T> factory, MobCategory category, float width, float height, int clientTrackingRange) {
        return ENTITY_TYPES.register(name, () -> EntityType.Builder.of((EntityType.EntityFactory)factory, (MobCategory)category).sized(width, height).build(name));
    }

    public static boolean shouldGiveEffect() {
        return (Boolean)MeadowNeoForgeConfig.GIVE_EFFECT.get();
    }

    public static boolean shouldShowTooltip() {
        return (Boolean)MeadowNeoForgeConfig.GIVE_EFFECT.get() != false && (Boolean)MeadowNeoForgeConfig.SHOW_TOOLTIP.get() != false;
    }

    public static boolean isModLoaded(String modid) {
        ModList list = ModList.get();
        if (list != null) {
            return list.isLoaded(modid);
        }
        return PlatformHelperImpl.isModPreLoaded(modid);
    }

    public static boolean isModPreLoaded(String modid) {
        return PlatformHelperImpl.getPreLoadedModInfo(modid) != null;
    }

    @Nullable
    public static ModInfo getPreLoadedModInfo(String modId) {
        for (ModInfo info : LoadingModList.get().getMods()) {
            if (!info.getModId().equals(modId)) continue;
            return info;
        }
        return null;
    }
}

