/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.satisfy.meadow.core.registry.RecipeRegistry;
import org.jetbrains.annotations.NotNull;

public class CookingCauldronRecipe
implements Recipe<RecipeInput> {
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final int fluidAmount;
    private final int craftingDuration;

    public CookingCauldronRecipe(NonNullList<Ingredient> inputs, ItemStack output, int fluidAmount, int craftingDuration) {
        this.inputs = inputs;
        this.output = output;
        this.fluidAmount = fluidAmount;
        this.craftingDuration = craftingDuration;
    }

    public boolean matches(RecipeInput inventory, Level level) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack s = inventory.getItem(i);
            if (s.isEmpty()) continue;
            items.add(s);
        }
        boolean[] used = new boolean[items.size()];
        for (Ingredient ing : this.inputs) {
            boolean ok = false;
            for (int i = 0; i < items.size(); ++i) {
                if (used[i] || !ing.test((ItemStack)items.get(i))) continue;
                used[i] = true;
                ok = true;
                break;
            }
            if (ok) continue;
            return false;
        }
        return true;
    }

    public ItemStack assemble() {
        return this.assemble(null, null);
    }

    @NotNull
    public ItemStack assemble(RecipeInput input, HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int w, int h) {
        return false;
    }

    public ItemStack getResultItem() {
        return this.getResultItem(null);
    }

    @NotNull
    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public int getFluidAmount() {
        return this.fluidAmount;
    }

    public int getCraftingDuration() {
        return this.craftingDuration;
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeRegistry.COOKING_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeRegistry.COOKING.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<CookingCauldronRecipe> {
        public static final MapCodec<CookingCauldronRecipe> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Ingredient.CODEC.listOf().fieldOf("ingredients").xmap(list -> {
            NonNullList nl = NonNullList.create();
            nl.addAll((Collection)list);
            return nl;
        }, List::copyOf).forGetter(r -> r.inputs), (App)ItemStack.CODEC.fieldOf("result").forGetter(r -> r.output), (App)Codec.INT.optionalFieldOf("fluid_amount", (Object)0).forGetter(r -> r.fluidAmount), (App)Codec.INT.optionalFieldOf("crafting_duration", (Object)10).forGetter(r -> r.craftingDuration)).apply((Applicative)i, CookingCauldronRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CookingCauldronRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.collection(NonNullList::createWithCapacity, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC), r -> r.inputs, (StreamCodec)ItemStack.STREAM_CODEC, r -> r.output, (StreamCodec)ByteBufCodecs.VAR_INT, r -> r.fluidAmount, (StreamCodec)ByteBufCodecs.VAR_INT, r -> r.craftingDuration, CookingCauldronRecipe::new);

        @NotNull
        public MapCodec<CookingCauldronRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, CookingCauldronRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

