/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.item;

import dev.architectury.core.item.ArchitecturySpawnEggItem;
import dev.architectury.registry.registries.RegistrySupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.satisfy.meadow.core.entity.WoolyCowEntity;
import net.satisfy.meadow.core.entity.WoolyCowVariant;
import org.jetbrains.annotations.NotNull;

public class CattleSpawnEggItem
extends ArchitecturySpawnEggItem {
    private final int variantId;

    public CattleSpawnEggItem(RegistrySupplier<? extends EntityType<? extends Animal>> type, int primary, int secondary, Item.Properties properties, int variantId) {
        super(type, primary, secondary, properties);
        this.variantId = variantId;
    }

    @NotNull
    public ItemStack getDefaultInstance() {
        ItemStack stack = super.getDefaultInstance();
        CompoundTag entityTag = new CompoundTag();
        entityTag.putInt("Variant", this.variantId);
        CompoundTag root = new CompoundTag();
        root.put("EntityTag", (Tag)entityTag);
        stack.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)root));
        return stack;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        Level level = ctx.getLevel();
        if (!(level instanceof ServerLevel)) {
            return super.useOn(ctx);
        }
        ServerLevel server = (ServerLevel)level;
        Direction face = ctx.getClickedFace();
        BlockPos spawnPos = ctx.getClickedPos().relative(face);
        EntityType type = this.getType(ctx.getItemInHand());
        Entity e = type.create((Level)server);
        if (e == null) {
            return InteractionResult.PASS;
        }
        e.moveTo((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, server.random.nextFloat() * 360.0f, 0.0f);
        if (e instanceof WoolyCowEntity) {
            WoolyCowEntity cow = (WoolyCowEntity)e;
            cow.setVariant(WoolyCowVariant.byId(this.variantId));
        }
        if (e instanceof Mob) {
            Mob mob = (Mob)e;
            DifficultyInstance diff = server.getCurrentDifficultyAt(spawnPos);
            mob.finalizeSpawn((ServerLevelAccessor)server, diff, MobSpawnType.SPAWN_EGG, null);
        }
        server.addFreshEntity(e);
        Player p = ctx.getPlayer();
        if (p == null || !p.getAbilities().instabuild) {
            ItemStack inHand = ctx.getItemInHand();
            inHand.shrink(1);
        }
        return InteractionResult.SUCCESS;
    }
}

