/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block.entity;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.satisfy.meadow.core.registry.EntityTypeRegistry;
import net.satisfy.meadow.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class CheeseRackBlockEntity
extends BlockEntity {
    private NonNullList<ItemStack> inventory = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);

    public CheeseRackBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.CHEESE_RACK_BLOCK_ENTITY.get(), pos, state);
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        ContainerHelper.saveAllItems((CompoundTag)compoundTag, this.inventory, (HolderLookup.Provider)provider);
        super.saveAdditional(compoundTag, provider);
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.inventory = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compoundTag, this.inventory, (HolderLookup.Provider)provider);
    }

    public ItemStack removeStack(int slot) {
        ItemStack stack = (ItemStack)this.inventory.set(slot, (Object)ItemStack.EMPTY);
        this.setChanged();
        return stack;
    }

    public void setStack(int slot, ItemStack stack) {
        this.inventory.set(slot, (Object)stack);
        this.setChanged();
    }

    public boolean hasStack(int slot) {
        return !((ItemStack)this.inventory.get(slot)).isEmpty();
    }

    public ItemStack getStack(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public Item[] getItems() {
        ArrayList<Item> items = new ArrayList<Item>();
        for (ItemStack stack : this.inventory) {
            if (stack.isEmpty()) continue;
            items.add(stack.getItem());
        }
        return items.toArray(new Item[0]);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public void setChanged() {
        if (this.level != null && !this.level.isClientSide()) {
            ClientboundBlockEntityDataPacket updatePacket = this.getUpdatePacket();
            for (ServerPlayer player : GeneralUtil.tracking((ServerLevel)this.level, this.getBlockPos())) {
                player.connection.send((Packet)updatePacket);
            }
        }
        super.setChanged();
    }
}

