/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SmokerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.meadow.core.block.TiledStoveBlockBench;
import net.satisfy.meadow.core.block.entity.StoveBlockEntity;
import net.satisfy.meadow.core.registry.EntityTypeRegistry;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TiledStoveBlockSmoker
extends SmokerBlock {
    public static final BooleanProperty CONNECTED = BooleanProperty.create((String)"connected");
    public static final VoxelShape SHAPE_BIG = Shapes.or((VoxelShape)TiledStoveBlockBench.SHAPE, (VoxelShape)Block.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
    private final Direction directionToCheck;

    public TiledStoveBlockSmoker(BlockBehaviour.Properties properties, Direction directionToCheck) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(false)));
        this.directionToCheck = directionToCheck;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        if (this.directionToCheck == Direction.DOWN && ((Boolean)state.getValue((Property)CONNECTED)).booleanValue()) {
            return super.getShape(state, world, pos, context);
        }
        return SHAPE_BIG;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        List<Block> block = this.getBlocksToCheck();
        if (!block.isEmpty() && block.contains(ctx.getLevel().getBlockState(ctx.getClickedPos().relative(this.directionToCheck)).getBlock())) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(true))).setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
        }
        return super.getStateForPlacement(ctx);
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        List<Block> block = this.getBlocksToCheck();
        if (!world.isClientSide() && !block.isEmpty() && direction == this.directionToCheck) {
            boolean connected = (Boolean)state.getValue((Property)CONNECTED);
            if (!connected) {
                if (block.contains(neighborState.getBlock())) {
                    return (BlockState)state.setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(true));
                }
            } else if (!block.contains(neighborState.getBlock())) {
                return (BlockState)state.setValue((Property)CONNECTED, (Comparable)Boolean.valueOf(false));
            }
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CONNECTED});
    }

    private List<Block> getBlocksToCheck() {
        if (this.directionToCheck == Direction.UP) {
            return List.of((Block)ObjectRegistry.TILED_STOVE.get());
        }
        if (this.directionToCheck == Direction.DOWN) {
            return List.of((Block)ObjectRegistry.TILED_STOVE_FIREPLACE.get(), (Block)ObjectRegistry.TILED_STOVE_SMOKER.get());
        }
        return List.of();
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (this == ObjectRegistry.TILED_STOVE_SMOKER.get()) {
            return null;
        }
        return new StoveBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (this == ObjectRegistry.TILED_STOVE_SMOKER.get()) {
            return null;
        }
        return TiledStoveBlockSmoker.createFurnaceTicker((Level)level, type, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.STOVE_BLOCK_ENTITY.get()));
    }
}

