/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.meadow.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShutterBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<GeneralUtil.ShutterType> TYPE = GeneralUtil.ShutterType.SHUTTER_TYPE;
    public static final BooleanProperty LEFT = BooleanProperty.create((String)"left");
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0)};

    public ShutterBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)((Object)GeneralUtil.ShutterType.NONE))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)LEFT, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int shape = ((Direction)state.getValue((Property)FACING)).get2DDataValue() + (((Boolean)state.getValue((Property)OPEN)).booleanValue() ? (((Boolean)state.getValue((Property)LEFT)).booleanValue() ? 3 : 1) : 0);
        return SHAPES[shape % 4];
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean left;
        Direction facing = context.getHorizontalDirection().getOpposite();
        BlockState blockState = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing);
        Level world = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        Vec3 clickLocation = context.getClickLocation();
        if (facing.getAxis() == Direction.Axis.X) {
            left = clickLocation.z - (double)clickedPos.getZ() > 0.5;
        } else {
            boolean bl = left = clickLocation.x - (double)clickedPos.getX() > 0.5;
        }
        if (context.getNearestLookingDirection() == Direction.NORTH || context.getNearestLookingDirection() == Direction.EAST) {
            left = !left;
        }
        blockState = (BlockState)blockState.setValue((Property)LEFT, (Comparable)Boolean.valueOf(left));
        if (world.hasNeighborSignal(clickedPos)) {
            blockState = (BlockState)((BlockState)blockState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(true))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        blockState = (BlockState)blockState.setValue(TYPE, (Comparable)((Object)this.getType(blockState, world.getBlockState(clickedPos.above()), world.getBlockState(clickedPos.below()))));
        return (BlockState)blockState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.getFluidState(clickedPos).getType() == Fluids.WATER));
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (world.isClientSide) {
            return;
        }
        boolean powered = world.hasNeighborSignal(pos);
        if (powered != (Boolean)state.getValue((Property)POWERED)) {
            if ((Boolean)state.getValue((Property)OPEN) != powered) {
                state = (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(powered));
                world.playSound(null, pos, ShutterBlock.shutterSound(powered), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (((Boolean)(state = (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered))).getValue((Property)WATERLOGGED)).booleanValue()) {
                world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
            }
        }
        GeneralUtil.ShutterType type = this.getType(state, world.getBlockState(pos.above()), world.getBlockState(pos.below()));
        if (state.getValue(TYPE) != type) {
            state = (BlockState)state.setValue(TYPE, (Comparable)((Object)type));
        }
        world.setBlock(pos, state, 3);
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult result = this.toggleShutters(state, level, pos, player);
        if (result.consumesAction()) {
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        return this.toggleShutters(state, level, pos, player);
    }

    public InteractionResult toggleShutters(BlockState state, Level level, BlockPos pos, Player player) {
        state = (BlockState)state.cycle((Property)OPEN);
        level.setBlock(pos, state, 3);
        if (player == null || !player.isCrouching()) {
            this.toggleShutters(state, level, pos, (Boolean)state.getValue((Property)OPEN));
        }
        level.playSound(null, pos, ShutterBlock.shutterSound((Boolean)state.getValue((Property)OPEN)), SoundSource.BLOCKS, 1.0f, 1.0f);
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void toggleShutters(BlockState state, Level level, BlockPos pos, boolean open) {
        int i;
        BlockState updateState = state;
        BlockPos updatePos = pos;
        if (state.getValue(TYPE) == GeneralUtil.ShutterType.MIDDLE || state.getValue(TYPE) == GeneralUtil.ShutterType.BOTTOM) {
            BlockState above;
            int heightUp = level.dimensionType().height() - updatePos.getY();
            for (i = 0; i < heightUp && (above = level.getBlockState(updatePos.above())).is(state.getBlock()) && above.getValue((Property)FACING) == updateState.getValue((Property)FACING) && above.getValue((Property)LEFT) == updateState.getValue((Property)LEFT) && (Boolean)above.getValue((Property)OPEN) != open; ++i) {
                updateState = above;
                updatePos = updatePos.above();
                level.setBlock(updatePos, (BlockState)updateState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            }
        }
        if (state.getValue(TYPE) == GeneralUtil.ShutterType.MIDDLE || state.getValue(TYPE) == GeneralUtil.ShutterType.TOP) {
            BlockState below;
            updateState = state;
            updatePos = pos;
            int heightDown = level.dimensionType().minY() - updatePos.getY();
            heightDown = heightDown < 0 ? -heightDown : heightDown;
            for (i = 0; i < heightDown && (below = level.getBlockState(updatePos.below())).is(state.getBlock()) && below.getValue((Property)FACING) == updateState.getValue((Property)FACING) && below.getValue((Property)LEFT) == updateState.getValue((Property)LEFT) && (Boolean)below.getValue((Property)OPEN) != open; ++i) {
                updateState = below;
                updatePos = updatePos.below();
                level.setBlock(updatePos, (BlockState)updateState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            }
        }
    }

    public static SoundEvent shutterSound(boolean open) {
        if (open) {
            return SoundEvents.BAMBOO_WOOD_DOOR_OPEN;
        }
        return SoundEvents.BAMBOO_WOOD_DOOR_CLOSE;
    }

    public GeneralUtil.ShutterType getType(BlockState state, BlockState above, BlockState below) {
        boolean shape_below_same;
        boolean shape_above_same = above.getBlock() == state.getBlock() && above.getValue((Property)FACING) == state.getValue((Property)FACING) && above.getValue((Property)OPEN) == state.getValue((Property)OPEN) && above.getValue((Property)LEFT) == state.getValue((Property)LEFT);
        boolean bl = shape_below_same = below.getBlock() == state.getBlock() && below.getValue((Property)FACING) == state.getValue((Property)FACING) && below.getValue((Property)OPEN) == state.getValue((Property)OPEN) && below.getValue((Property)LEFT) == state.getValue((Property)LEFT);
        if (shape_above_same && !shape_below_same) {
            return GeneralUtil.ShutterType.BOTTOM;
        }
        if (!shape_above_same && shape_below_same) {
            return GeneralUtil.ShutterType.TOP;
        }
        if (shape_above_same) {
            return GeneralUtil.ShutterType.MIDDLE;
        }
        return GeneralUtil.ShutterType.NONE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TYPE, OPEN, LEFT, POWERED, WATERLOGGED});
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

