/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.meadow.core.block.FacingBlock;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import net.satisfy.meadow.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class FireLog
extends FacingBlock {
    public static final IntegerProperty STAGE = IntegerProperty.create((String)"stage", (int)0, (int)3);
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.make(new HashMap(), map -> {
        VoxelShape baseShape = FireLog.makeDefaultShape();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, baseShape));
        }
    });

    public FireLog(BlockBehaviour.Properties setting) {
        super(setting);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)STAGE, (Comparable)Integer.valueOf(1)));
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        int stage = (Integer)state.getValue((Property)STAGE);
        VoxelShape shape = switch (stage) {
            case 1 -> this.makeSmallShape();
            case 2 -> this.makeMidShape();
            case 3 -> this.makeBigShape();
            default -> this.makeAxeShape();
        };
        return GeneralUtil.rotateShape(Direction.NORTH, facing, shape);
    }

    private static VoxelShape makeDefaultShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.5, (double)0.75), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    @NotNull
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int stage = (Integer)state.getValue((Property)STAGE);
        if (stack.is(this.asItem()) && stage < 3) {
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(stage + 1)));
            level.playSound(null, pos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        int stage = (Integer)state.getValue((Property)STAGE);
        if (player.isShiftKeyDown() && stage > 1) {
            player.addItem(new ItemStack((ItemLike)ObjectRegistry.FIRE_LOG.get()));
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)STAGE, (Comparable)Integer.valueOf(stage - 1)));
            level.playSound(null, pos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (stage == 0) {
            level.removeBlock(pos, true);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{STAGE});
    }

    private VoxelShape makeAxeShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.078125, (double)0.0, (double)0.125, (double)0.328125, (double)0.25, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.546875, (double)0.0, (double)0.0625, (double)0.796875, (double)0.25, (double)0.4375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.546875, (double)0.0, (double)0.5625, (double)0.796875, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private VoxelShape makeSmallShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.0, (double)0.1875, (double)0.625, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.0, (double)0.125, (double)0.875, (double)0.25, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5625, (double)0.25, (double)0.0625, (double)0.8125, (double)0.5, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.25, (double)0.125, (double)0.5625, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.5, (double)0.1875, (double)0.6875, (double)0.75, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.375, (double)0.25, (double)0.875), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private VoxelShape makeMidShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.0, (double)0.1875, (double)0.5, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.0, (double)0.0625, (double)0.75, (double)0.25, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.0, (double)0.125, (double)1.0, (double)0.25, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.125, (double)0.25, (double)0.25, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.375, (double)0.25, (double)0.1875, (double)0.625, (double)0.5, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.625, (double)0.25, (double)0.125, (double)0.875, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5625, (double)0.5, (double)0.0625, (double)0.8125, (double)0.75, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.3125, (double)0.5, (double)0.125, (double)0.5625, (double)0.75, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.4375, (double)0.75, (double)0.1875, (double)0.6875, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.125, (double)0.25, (double)0.125, (double)0.375, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    private VoxelShape makeBigShape() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.0, (double)0.1875, (double)0.5, (double)0.25, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.0, (double)0.0625, (double)0.75, (double)0.25, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.0, (double)0.125, (double)1.0, (double)0.25, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.125, (double)0.25, (double)0.25, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.25, (double)0.1875, (double)0.75, (double)0.5, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.25, (double)0.125, (double)1.0, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.5, (double)0.0625, (double)1.0, (double)0.75, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.5, (double)0.125, (double)0.75, (double)0.75, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.75, (double)0.125, (double)1.0, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.25, (double)0.125, (double)0.5, (double)0.5, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.25, (double)0.1875, (double)0.25, (double)0.5, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.5, (double)0.125, (double)0.25, (double)0.75, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.5, (double)0.1875, (double)0.5, (double)0.75, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.75, (double)0.1875, (double)0.25, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.75, (double)0.0625, (double)0.75, (double)1.0, (double)0.8125), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.75, (double)0.1875, (double)0.5, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.OR);
        return shape;
    }
}

