/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.meadow.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class ClimbingRopeBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);

    public ClimbingRopeBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!world.isClientSide()) {
            BlockState blockState = world.getBlockState(pos.above());
            if (blockState.is((Block)ObjectRegistry.CLIMBING_ROPE.get()) || blockState.is((Block)ObjectRegistry.CLIMBING_ROPE_TOPMOUNT.get())) {
                return state;
            }
            world.destroyBlock(pos, true);
            return world.getBlockState(pos);
        }
        return state;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

