/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.meadow.core.registry.SoundEventRegistry;
import net.satisfy.meadow.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class CameraBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final Supplier<VoxelShape> SHAPE_SUPPLIER = () -> {
        VoxelShape base = Shapes.box((double)0.25, (double)0.9375, (double)0.1875, (double)0.75, (double)1.4375, (double)0.8125);
        VoxelShape lens = Shapes.box((double)0.4375, (double)1.125, (double)-0.125, (double)0.5625, (double)1.25, (double)0.1875);
        return Shapes.or((VoxelShape)base, (VoxelShape)lens);
    };
    private static final Map<Direction, VoxelShape> SHAPES = (Map)Util.make(new HashMap(), map -> {
        VoxelShape lens = SHAPE_SUPPLIER.get();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, GeneralUtil.rotateShape(Direction.NORTH, direction, lens));
        }
    });

    public CameraBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    @NotNull
    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        world.playSound(null, pos, (SoundEvent)SoundEventRegistry.CLICK_CAMERA.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        if (world.isClientSide) {
            Direction direction = (Direction)state.getValue((Property)FACING);
            double xBase = (double)pos.getX() + 0.5;
            double yBase = (double)pos.getY() + 0.7;
            double zBase = (double)pos.getZ() + 0.5;
            double offset = 0.5 * (double)direction.getStepX();
            double noise = ((double)world.random.nextFloat() - 0.5) * 0.5;
            for (int i = 0; i < 5; ++i) {
                double x = xBase + offset;
                double z = zBase + noise * (double)direction.getStepZ();
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, x, yBase, z, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.FIREWORK, x, yBase, z, 0.0, 0.0, 0.0);
                world.addParticle((ParticleOptions)ParticleTypes.CRIT, x + 0.3125 * (double)direction.getStepX(), yBase, z, 0.0, 0.0, 0.0);
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getOpposite());
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

