/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.client.gui.handler;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.FurnaceResultSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.satisfy.meadow.core.registry.ScreenHandlerRegistry;
import org.jetbrains.annotations.NotNull;

public class CheeseFormGuiHandler
extends AbstractContainerMenu {
    private final ContainerData propertyDelegate;

    public CheeseFormGuiHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(3), (ContainerData)new SimpleContainerData(2));
    }

    public CheeseFormGuiHandler(int syncId, Inventory playerInventory, Container inventory, ContainerData propertyDelegate) {
        super((MenuType)ScreenHandlerRegistry.CHEESE_FORM_SCREEN_HANDLER.get(), syncId);
        this.propertyDelegate = propertyDelegate;
        this.addDataSlots(propertyDelegate);
        this.buildBlockEntityContainer(playerInventory, inventory);
        this.buildPlayerContainer(playerInventory);
    }

    private void buildBlockEntityContainer(Inventory playerInventory, Container inventory) {
        this.addSlot((Slot)new FurnaceResultSlot(playerInventory.player, inventory, 0, 123, 34));
        this.addSlot(new Slot(inventory, 1, 33, 33));
        this.addSlot(new Slot(inventory, 2, 51, 33));
    }

    private void buildPlayerContainer(Inventory playerInventory) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public int getScaledXProgress() {
        int progress = this.propertyDelegate.get(0);
        int totalProgress = this.propertyDelegate.get(1);
        if (progress <= 0 || totalProgress <= 0) {
            return 0;
        }
        return progress * 24 / totalProgress;
    }

    public int getScaledYProgress() {
        int progress = this.propertyDelegate.get(0);
        int totalProgress = this.propertyDelegate.get(1);
        if (progress <= 0 || totalProgress <= 0) {
            return 0;
        }
        return progress * 25 / totalProgress;
    }

    public int getCookingTime() {
        return this.propertyDelegate.get(0);
    }

    public int getRequiredDuration() {
        return this.propertyDelegate.get(1);
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = slot.getItem();
        ItemStack originalStack = stack.copy();
        if (index == 0) {
            if (!this.moveItemStackTo(stack, 3, this.slots.size(), true)) {
                return ItemStack.EMPTY;
            }
            slot.onQuickCraft(stack, originalStack);
        } else if (index >= 3 && index < this.slots.size() ? !this.moveItemStackTo(stack, 1, 3, false) : index >= 1 && index < 3 && !this.moveItemStackTo(stack, 3, this.slots.size(), false)) {
            return ItemStack.EMPTY;
        }
        if (stack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (stack.getCount() == originalStack.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(player, stack);
        return originalStack;
    }

    public boolean stillValid(Player player) {
        return true;
    }
}

