/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.satisfy.meadow.Meadow;
import net.satisfy.meadow.client.gui.handler.CookingCauldronGuiHandler;
import org.joml.Vector2i;

public class CookingCauldronGui
extends AbstractContainerScreen<CookingCauldronGuiHandler> {
    private static final ResourceLocation BACKGROUND = Meadow.identifier("textures/gui/cooking_cauldron_gui.png");
    private static final int ARROW_X = 70;
    private static final int ARROW_Y = 27;
    private static final int FLUID_X = 157;
    private static final int FLUID_Y = 23;
    private static final int FLUID_WIDTH = 8;
    private static final int FLUID_HEIGHT = 43;
    private final Vector2i screenPos = new Vector2i();

    public CookingCauldronGui(CookingCauldronGuiHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
    }

    protected void init() {
        super.init();
        this.screenPos.set(this.leftPos, this.topPos);
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(BACKGROUND, this.screenPos.x(), this.screenPos.y(), 0, 0, this.imageWidth, this.imageHeight);
        this.renderProgressArrow(guiGraphics);
        this.renderBurnIcon(guiGraphics);
        this.renderFluidBar(guiGraphics);
    }

    private void renderProgressArrow(GuiGraphics guiGraphics) {
        int progress = ((CookingCauldronGuiHandler)this.menu).getScaledProgress(24);
        guiGraphics.blit(BACKGROUND, this.screenPos.x() + 70, this.screenPos.y() + 27, 176, 14, progress, 17);
    }

    private void renderBurnIcon(GuiGraphics guiGraphics) {
        if (((CookingCauldronGuiHandler)this.menu).isBeingBurned()) {
            guiGraphics.blit(BACKGROUND, this.screenPos.x() + 108, this.screenPos.y() + 52, 176, 0, 14, 14);
        }
    }

    private void renderFluidBar(GuiGraphics guiGraphics) {
        int fluidLevel = ((CookingCauldronGuiHandler)this.menu).getFluidLevel();
        int filledHeight = fluidLevel * 43 / 100;
        guiGraphics.blit(BACKGROUND, this.screenPos.x() + 157, this.screenPos.y() + 23 + 43 - filledHeight, 176, 74 - filledHeight, 8, filledHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        if (this.isMouseOverFluidArea(mouseX, mouseY)) {
            int fluidLevel = ((CookingCauldronGuiHandler)this.menu).getFluidLevel();
            MutableComponent tooltip = Component.translatable((String)"tooltip.meadow.cooking_cauldron.water_level", (Object[])new Object[]{fluidLevel});
            guiGraphics.renderTooltip(this.font, (Component)tooltip, mouseX, mouseY);
        }
        if (this.isMouseOverProgressArrow(mouseX, mouseY)) {
            int remainingTicks = ((CookingCauldronGuiHandler)this.menu).getRequiredDuration() - ((CookingCauldronGuiHandler)this.menu).getCookingTime();
            String formattedTime = this.formatTicks(remainingTicks);
            MutableComponent tooltip = Component.translatable((String)"tooltip.meadow.cooking_cauldron.remaining_time", (Object[])new Object[]{formattedTime});
            guiGraphics.renderTooltip(this.font, (Component)tooltip, mouseX, mouseY);
        }
        super.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private boolean isMouseOverFluidArea(int mouseX, int mouseY) {
        int left = this.screenPos.x() + 157;
        int top = this.screenPos.y() + 23;
        return mouseX >= left && mouseX < left + 8 && mouseY >= top && mouseY < top + 43;
    }

    private boolean isMouseOverProgressArrow(int mouseX, int mouseY) {
        int left = this.screenPos.x() + 70;
        int top = this.screenPos.y() + 27;
        return mouseX >= left && mouseX < left + 24 && mouseY >= top && mouseY < top + 17;
    }

    private String formatTicks(int ticks) {
        int seconds = ticks / 20;
        int minutes = seconds / 60;
        return String.format("%d:%02d", minutes, seconds %= 60);
    }
}

