/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.meadow.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.satisfy.meadow.Meadow;
import net.satisfy.meadow.client.gui.handler.CheeseFormGuiHandler;
import org.joml.Vector2i;

public class CheeseFormGui
extends AbstractContainerScreen<CheeseFormGuiHandler> {
    public static final ResourceLocation BACKGROUND = Meadow.identifier("textures/gui/cheese_form_gui.png");
    public static final int ARROW_X = 78;
    public static final int ARROW_Y = 36;
    public static final int TIME_X = 81;
    public static final int TIME_Y = 8;
    private final Vector2i screenPos = new Vector2i();

    public CheeseFormGui(CheeseFormGuiHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.font = Minecraft.getInstance().font;
    }

    protected void renderBg(GuiGraphics guiGraphics, float f, int i, int j) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        int posX = this.leftPos;
        int posY = this.topPos;
        guiGraphics.blit(BACKGROUND, posX, posY, 0, 0, this.imageWidth - 1, this.imageHeight);
        this.renderProgressArrow(guiGraphics);
    }

    protected void renderProgressArrow(GuiGraphics guiGraphics) {
        int progressX = ((CheeseFormGuiHandler)this.menu).getScaledXProgress();
        guiGraphics.blit(BACKGROUND, this.leftPos + 78, this.topPos + 36, 176, 4, progressX, 10);
        int progressY = ((CheeseFormGuiHandler)this.menu).getScaledYProgress();
        guiGraphics.blit(BACKGROUND, this.leftPos + 81, this.topPos + 8, 180, 22, 16, progressY);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.screenPos.set(this.leftPos, this.topPos);
        if (this.isMouseOverProgressArrow(mouseX, mouseY)) {
            int remainingTicks = Math.max(((CheeseFormGuiHandler)this.menu).getRequiredDuration() - ((CheeseFormGuiHandler)this.menu).getCookingTime(), 0);
            String formattedTime = this.formatTicks(remainingTicks);
            MutableComponent tooltip = Component.translatable((String)"tooltip.meadow.cooking_cauldron.remaining_time", (Object[])new Object[]{formattedTime});
            guiGraphics.renderTooltip(this.font, (Component)tooltip, mouseX, mouseY);
        } else {
            super.renderTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    private boolean isMouseOverProgressArrow(int mouseX, int mouseY) {
        int left = this.screenPos.x() + 78;
        int top = this.screenPos.y() + 36;
        return mouseX >= left && mouseX < left + 24 && mouseY >= top && mouseY < top + 17;
    }

    private String formatTicks(int ticks) {
        int seconds = Math.max(ticks / 20, 0);
        int minutes = seconds / 60;
        return String.format("%d:%02d", minutes, seconds %= 60);
    }
}

