/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.mixins;

import net.mehvahdjukaar.moonlight.api.misc.OptionalMixin;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.common.block.IConvertableHorse;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OptionalMixin(value="com.github.alexthe668.domesticationinnovation.DomesticationMod", classLoaded=false)
@Mixin(value={ZombieHorse.class})
public abstract class ZombieHorseMixin
extends AbstractHorse
implements IConvertableHorse {
    @Unique
    private static final int CONV_TIME = 4600;
    @Unique
    private int supplementaries$conversionTime = -1;

    protected ZombieHorseMixin(EntityType<? extends AbstractHorse> entityType, Level level) {
        super(entityType, level);
    }

    public boolean dismountsUnderwater() {
        return false;
    }

    @Unique
    public void supp$startConverting() {
        if (!this.supp$isConverting()) {
            this.supplementaries$conversionTime = 4600;
            this.level().broadcastEntityEvent((Entity)this, (byte)16);
            this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 4600, 2));
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("ConversionTime", this.supplementaries$conversionTime);
    }

    public void readAdditionalSaveData(CompoundTag compoundNBT) {
        this.addAdditionalSaveData(compoundNBT);
        this.supplementaries$conversionTime = compoundNBT.getInt("ConversionTime");
    }

    @Override
    public boolean supp$isConverting() {
        return this.supplementaries$conversionTime > 0;
    }

    @Unique
    private void supp$doHorseConversion() {
        float yBodyRot = this.yBodyRot;
        float yHeadRot = this.yHeadRot;
        float yBodyRotO = this.yBodyRotO;
        float yHeadRotO = this.yHeadRotO;
        AbstractHorse newHorse = (AbstractHorse)this.convertTo(EntityType.HORSE, true);
        if (newHorse != null) {
            newHorse.yBodyRot = yBodyRot;
            newHorse.yHeadRot = yHeadRot;
            newHorse.yHeadRotO = yHeadRotO;
            newHorse.setOwnerUUID(this.getOwnerUUID());
            newHorse.setTamed(this.isTamed());
            newHorse.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
            if (this.isSaddled()) {
                newHorse.equipSaddle(new ItemStack((ItemLike)Items.SADDLE), null);
            }
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack itemstack = this.getItemBySlot(slot);
                if (itemstack.isEmpty()) continue;
                if (EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) {
                    newHorse.getSlot(slot.getIndex() + 300).set(itemstack);
                    continue;
                }
                double d0 = this.getEquipmentDropChance(slot);
                if (!(d0 > 1.0)) continue;
                this.spawnAtLocation(itemstack);
            }
            ForgeHelper.fireOnLivingConvert((LivingEntity)this, (LivingEntity)newHorse);
        }
        if (!this.isSilent()) {
            this.level().levelEvent(null, 1027, this.blockPosition(), 0);
        }
    }

    public void handleEntityEvent(byte pId) {
        if (pId == 16) {
            this.supplementaries$conversionTime = 4600;
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getEyeY(), this.getZ(), SoundEvents.ZOMBIE_VILLAGER_CURE, this.getSoundSource(), 1.0f + this.random.nextFloat(), this.random.nextFloat() * 0.7f + 0.3f, false);
            }
        } else {
            super.handleEntityEvent(pId);
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.isAlive() && !this.isNoAi() && this.supp$isConverting()) {
            --this.supplementaries$conversionTime;
            if (this.supplementaries$conversionTime == 0) {
                this.supp$doHorseConversion();
            }
        }
    }

    @Inject(method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    public void supp$interact(Player pPlayer, InteractionHand pHand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack itemstack = pPlayer.getItemInHand(pHand);
        if (itemstack.is(Items.GOLDEN_CARROT) && this.hasEffect(MobEffects.WEAKNESS) && CommonConfigs.Tweaks.ZOMBIE_HORSE_CONVERSION.get().booleanValue()) {
            if (!pPlayer.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
            Level level = this.level();
            this.eat(level, itemstack);
            if (!level.isClientSide) {
                this.supp$startConverting();
            }
            cir.cancel();
            cir.setReturnValue((Object)InteractionResult.sidedSuccess((boolean)level.isClientSide));
        }
    }
}

