/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.supplementaries.common.entities.CannonBoatEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;

public class SpawnEntityWithPassengersFeature
extends Feature<Config> {
    public SpawnEntityWithPassengersFeature() {
        super(Config.CODEC);
    }

    public boolean place(FeaturePlaceContext<Config> context) {
        Config config = (Config)context.config();
        BlockPos blockPos = context.origin();
        WorldGenLevel level = context.level();
        ServerLevel serverLevel = level.getLevel();
        for (int i = 0; i < config.attempts + 5; ++i) {
            BlockPos groundPos;
            int dx = context.random().nextIntBetweenInclusive(-config.spread, config.spread);
            int dz = context.random().nextIntBetweenInclusive(-config.spread, config.spread);
            BlockPos spawnPos = blockPos.offset(dx, 0, dz);
            if (config.projection == StructureTemplatePool.Projection.TERRAIN_MATCHING) {
                int y = level.getHeight(Heightmap.Types.WORLD_SURFACE_WG, blockPos.getX(), blockPos.getZ());
                spawnPos = spawnPos.atY(y);
            }
            if (!level.isEmptyBlock(spawnPos) || !config.groundRule.test(level.getBlockState(groundPos = spawnPos.below()), context.random()) || !SpawnEntityWithPassengersFeature.trySpawningAt(context, config, serverLevel, spawnPos, level)) continue;
            return true;
        }
        return false;
    }

    private static boolean trySpawningAt(FeaturePlaceContext<Config> context, Config config, ServerLevel serverLevel, BlockPos blockPos, WorldGenLevel worldgenLevel) {
        Entity boat = config.entity.create((Level)serverLevel);
        if (boat == null) {
            return false;
        }
        if (boat instanceof Boat) {
            Boat b = (Boat)boat;
            if (config.data.boatType.isPresent()) {
                b.setVariant(config.data.boatType.get().toVanillaBoat());
                if (boat instanceof CannonBoatEntity) {
                    CannonBoatEntity cb = (CannonBoatEntity)boat;
                    cb.setWoodType(config.data.boatType.get());
                }
            }
        }
        if (boat instanceof ContainerEntity) {
            ContainerEntity cb = (ContainerEntity)boat;
            if (config.data.lootTable.isPresent()) {
                cb.setLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)config.data.lootTable.get()));
            }
        }
        boat.moveTo((double)blockPos.getX() + 0.5, (double)blockPos.getY(), (double)blockPos.getZ() + 0.5, 360.0f * context.random().nextFloat(), 0.0f);
        for (EntityType<?> passengerType : config.passengers) {
            Entity passenger = passengerType.create((Level)serverLevel);
            if (passenger == null) continue;
            passenger.startRiding(boat);
        }
        for (Entity e : boat.getSelfAndPassengers().toList()) {
            if (!(e instanceof Mob)) continue;
            Mob m = (Mob)e;
            if (config.persistent) {
                m.setPersistenceRequired();
            }
            m.finalizeSpawn((ServerLevelAccessor)worldgenLevel, worldgenLevel.getCurrentDifficultyAt(blockPos), MobSpawnType.STRUCTURE, null);
        }
        if (!worldgenLevel.hasChunkAt(blockPos) || !worldgenLevel.noCollision(boat)) {
            return false;
        }
        serverLevel.addFreshEntityWithPassengers(boat);
        return true;
    }

    public record Config(EntityType<?> entity, List<EntityType<?>> passengers, int spread, StructureTemplatePool.Projection projection, int attempts, RuleTest groundRule, boolean persistent, ExtraData data) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entity").forGetter(Config::entity), (App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().listOf().optionalFieldOf("passengers", List.of()).forGetter(Config::passengers), (App)Codec.INT.optionalFieldOf("spread", (Object)0).forGetter(Config::spread), (App)StructureTemplatePool.Projection.CODEC.optionalFieldOf("projection", (Object)StructureTemplatePool.Projection.RIGID).forGetter(Config::projection), (App)Codec.INT.optionalFieldOf("attempts", (Object)1).forGetter(Config::attempts), (App)RuleTest.CODEC.optionalFieldOf("ground_rule", (Object)AlwaysTrueTest.INSTANCE).forGetter(Config::groundRule), (App)Codec.BOOL.optionalFieldOf("persistent", (Object)true).forGetter(Config::persistent), (App)ExtraData.CODEC.optionalFieldOf("data", (Object)ExtraData.EMPTY).forGetter(Config::data)).apply((Applicative)instance, Config::new));
    }

    record ExtraData(Optional<WoodType> boatType, Optional<ResourceLocation> lootTable) {
        private static final Codec<ExtraData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)WoodType.CODEC.optionalFieldOf("boat_type").forGetter(ExtraData::boatType), (App)ResourceLocation.CODEC.optionalFieldOf("loot_table").forGetter(ExtraData::lootTable)).apply((Applicative)instance, ExtraData::new));
        public static final ExtraData EMPTY = new ExtraData(Optional.empty(), Optional.empty());
    }
}

