/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.crafting;

import net.mehvahdjukaar.supplementaries.common.items.BambooSpikesTippedItem;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRecipes;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class TippedBambooSpikesRecipe
extends CustomRecipe {
    public TippedBambooSpikesRecipe(CraftingBookCategory category) {
        super(category);
    }

    private boolean isEmptySpike(ItemStack stack) {
        if (stack.getItem() == ModRegistry.BAMBOO_SPIKES_TIPPED_ITEM.get()) {
            Integer charges = (Integer)stack.get(ModComponents.CHARGES.get());
            return charges == null || charges == 0;
        }
        return stack.is(ModRegistry.BAMBOO_SPIKES_ITEM.get());
    }

    public boolean matches(CraftingInput inv, Level level) {
        ItemStack itemstack = null;
        ItemStack stack1 = null;
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (this.isEmptySpike(stack)) {
                if (itemstack != null) {
                    return false;
                }
                itemstack = stack;
                continue;
            }
            if (stack.getItem() == Items.LINGERING_POTION) {
                PotionContents potion = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
                if (potion == null) {
                    return false;
                }
                if (!BambooSpikesTippedItem.isPotionValid(potion)) {
                    return false;
                }
                if (stack1 != null) {
                    return false;
                }
                stack1 = stack;
                continue;
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        return itemstack != null && stack1 != null;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider provider) {
        PotionContents potion = PotionContents.EMPTY;
        for (int i = 0; i < inv.size(); ++i) {
            PotionContents p = (PotionContents)inv.getItem(i).getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            if (p == PotionContents.EMPTY) continue;
            potion = p;
            break;
        }
        ItemStack returnStack = ModRegistry.BAMBOO_SPIKES_TIPPED_ITEM.get().getDefaultInstance();
        returnStack.set(DataComponents.POTION_CONTENTS, (Object)potion);
        return returnStack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.BAMBOO_SPIKES_TIPPED.get();
    }
}

