/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.moonlight.api.block.ItemDisplayTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FrameBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.ItemShelfBlock;
import net.mehvahdjukaar.supplementaries.common.utils.FlowerPotHandler;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVinesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class FlowerBoxBlockTile
extends ItemDisplayTile
implements IBlockHolder,
IExtraModelDataProvider {
    public static final ModelDataKey<BlockState> FLOWER_0 = ModBlockProperties.FLOWER_0;
    public static final ModelDataKey<BlockState> FLOWER_1 = ModBlockProperties.FLOWER_1;
    public static final ModelDataKey<BlockState> FLOWER_2 = ModBlockProperties.FLOWER_2;
    private final BlockState[] flowerStates = new BlockState[]{Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState()};

    public FlowerBoxBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.FLOWER_BOX_TILE.get(), pos, state, 3);
    }

    public BlockState getHeldBlock(int index) {
        return this.flowerStates[index];
    }

    public boolean setHeldBlock(BlockState state, int index) {
        if (index >= 0 && index < 3) {
            this.flowerStates[index] = state;
        }
        return false;
    }

    public void updateTileOnInventoryChanged() {
        super.updateTileOnInventoryChanged();
        for (int n = 0; n < this.getContainerSize(); ++n) {
            this.setBlockFromItem(n, this.getItem(n).getItem());
        }
        this.updateLight();
    }

    private void updateLight() {
        if (this.level instanceof ServerLevel) {
            int newLight = Math.max(Math.max(ForgeHelper.getLightEmission((BlockState)this.getHeldBlock(), (Level)this.level, (BlockPos)this.worldPosition), ForgeHelper.getLightEmission((BlockState)this.getHeldBlock(1), (Level)this.level, (BlockPos)this.worldPosition)), ForgeHelper.getLightEmission((BlockState)this.getHeldBlock(2), (Level)this.level, (BlockPos)this.worldPosition));
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)FrameBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(newLight)), 3);
        }
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        builder.with(FLOWER_0, (Object)this.flowerStates[0]).with(FLOWER_1, (Object)this.flowerStates[1]).with(FLOWER_2, (Object)this.flowerStates[2]);
    }

    public void updateClientVisualsOnLoad() {
        for (int n = 0; n < this.flowerStates.length; ++n) {
            Item item = this.getItem(n).getItem();
            this.setBlockFromItem(n, item);
        }
        this.requestModelReload();
    }

    private void setBlockFromItem(int n, Item item) {
        Block b = null;
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            b = bi.getBlock();
        } else if (CompatHandler.DYNAMICTREES) {
            b = CompatHandler.DynTreesGetOptionalDynamicSapling(item, this.level, this.worldPosition);
        }
        if (b == null) {
            b = Blocks.AIR;
        }
        BlockState state = b.defaultBlockState();
        if (b == Blocks.CAVE_VINES) {
            state = (BlockState)state.setValue((Property)CaveVinesBlock.BERRIES, (Comparable)Boolean.valueOf(true));
        }
        this.flowerStates[n] = state;
    }

    public float getYaw() {
        return -this.getDirection().getOpposite().toYRot();
    }

    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)ItemShelfBlock.FACING);
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        if (this.getItem(index).isEmpty()) {
            if (FlowerPotHandler.hasSpecialFlowerModel(stack.getItem())) {
                return true;
            }
            if (CommonConfigs.Building.FLOWER_BOX_SIMPLE_MODE.get().booleanValue()) {
                return false;
            }
            return stack.getItem() instanceof BlockItem && stack.is(ModTags.FLOWER_BOX_PLANTABLE);
        }
        return false;
    }

    public SoundEvent getAddItemSound() {
        return SoundEvents.CROP_PLANTED;
    }
}

