/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.block.IRotatable;
import net.mehvahdjukaar.moonlight.api.misc.TileOrEntityTarget;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.block.IAnalogRotatable;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.AlternativeBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.GenericProjectileBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.IFireItemBehavior;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.SlingshotBehavior;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundControlCannonPacket;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.common.utils.MiscUtils;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class CannonBlock
extends DirectionalBlock
implements EntityBlock,
ILightable,
IRotatable,
IAnalogRotatable {
    public static final int MAX_POWER_LEVELS = 4;
    public static final MapCodec<CannonBlock> CODEC = CannonBlock.simpleCodec(CannonBlock::new);
    private static final Map<Item, IFireItemBehavior> FIRE_BEHAVIORS = new Object2ObjectOpenHashMap();
    private static final IFireItemBehavior DEFAULT = new AlternativeBehavior(new GenericProjectileBehavior(), new SlingshotBehavior());
    protected static final VoxelShape SHAPE_DOWN = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape SHAPE_UP = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape SHAPE_EAST = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_WEST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final EnumProperty<Rotation> ROTATE_TILE = ModBlockProperties.ROTATE_TILE;

    public CannonBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue(ROTATE_TILE, (Comparable)Rotation.NONE)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return CODEC;
    }

    public static void clearBehaviors() {
        FIRE_BEHAVIORS.clear();
    }

    public static void registerBehavior(ItemLike pItem, IFireItemBehavior pBehavior) {
        FIRE_BEHAVIORS.put(pItem.asItem(), pBehavior);
    }

    public static IFireItemBehavior getCannonBehavior(ItemLike item) {
        return FIRE_BEHAVIORS.getOrDefault(item, DEFAULT);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (!MiscUtils.showsHints(tooltipFlag)) {
            return;
        }
        tooltipComponents.add((Component)Component.translatable((String)"message.supplementaries.cannon").withStyle(ChatFormatting.GRAY).withStyle(ChatFormatting.ITALIC));
    }

    @Nullable
    public MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)blockEntity;
            return tile;
        }
        return null;
    }

    public boolean canBeReplaced(BlockState state, Fluid fluid) {
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, POWERED, ROTATE_TILE});
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public float getShadeBrightness(BlockState state, BlockGetter level, BlockPos pos) {
        return 1.0f;
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)))).setValue(ROTATE_TILE, (Comparable)((Rotation)state.getValue(ROTATE_TILE)).getRotated(rot));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        super.setPlacedBy(level, pos, state, placer, stack);
        if (placer != null && (blockEntity = level.getBlockEntity(pos)) instanceof CannonBlockTile) {
            CannonBlockTile cannon = (CannonBlockTile)blockEntity;
            Direction dir = Direction.orderedByNearest((Entity)placer)[0];
            Direction myDir = ((Direction)state.getValue((Property)FACING)).getOpposite();
            if (dir.getAxis() == Direction.Axis.Y) {
                float pitch = dir == Direction.UP ? -90.0f : 90.0f;
                cannon.setPitch(cannon.selfAccess, myDir.getOpposite() == dir ? pitch + 180.0f : pitch);
            } else {
                float yaw = dir.toYRot();
                cannon.setYaw(cannon.selfAccess, myDir.getOpposite() == dir ? yaw + 180.0f : yaw);
            }
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean wasPowered;
        if (!level.isClientSide && (wasPowered = ((Boolean)state.getValue((Property)POWERED)).booleanValue()) != level.hasNeighborSignal(pos)) {
            BlockEntity blockEntity;
            level.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
            if (!wasPowered && (blockEntity = level.getBlockEntity(pos)) instanceof CannonBlockTile) {
                CannonBlockTile tile = (CannonBlockTile)blockEntity;
                tile.ignite(null, tile.selfAccess);
            }
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CannonBlockTile(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return Utils.getTicker(pBlockEntityType, ModRegistry.CANNON_TILE.get(), CannonBlock::tickTile);
    }

    private static void tickTile(Level level, BlockPos pos, BlockState state, CannonBlockTile cannonBlockTile) {
        cannonBlockTile.tick(cannonBlockTile.selfAccess);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemInteractionResult r = this.lightableInteractWithPlayerItem(state, level, pos, player, hand, stack);
        if (r.consumesAction()) {
            return r;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                if (player.isSecondaryUseActive()) {
                    if (tile.canBeUsedBy(pos, (Entity)player)) {
                        tile.setCurrentUser(player.getUUID());
                        NetworkHelper.sendToClientPlayer((ServerPlayer)sp, (CustomPacketPayload)new ClientBoundControlCannonPacket(TileOrEntityTarget.of((BlockEntity)tile)));
                    }
                } else {
                    Utils.openGuiIfPossible((BlockEntity)tile, (ServerPlayer)sp, (ItemStack)stack, (Direction)hitResult.getDirection());
                }
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        Containers.dropContentsOnDestroy((BlockState)state, (BlockState)newState, (Level)level, (BlockPos)pos);
        super.onRemove(state, level, pos, newState, isMoving);
    }

    public boolean isLitUp(BlockState state, BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)blockEntity;
            return tile.isFiring();
        }
        return false;
    }

    public boolean tryLightUp(@Nullable Entity player, BlockState state, BlockPos pos, LevelAccessor world, ILightable.FireSoundType fireSourceType) {
        CannonBlockTile tile;
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof CannonBlockTile && !(tile = (CannonBlockTile)blockEntity).readyToFire()) {
            return false;
        }
        return super.tryLightUp(player, state, pos, world, fireSourceType);
    }

    public void setLitUp(BlockState blockState, LevelAccessor levelAccessor, BlockPos blockPos, @Nullable Entity igniter, boolean on) {
        BlockEntity blockEntity = levelAccessor.getBlockEntity(blockPos);
        if (blockEntity instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)blockEntity;
            tile.ignite(igniter, tile.selfAccess);
        }
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return switch (((Direction)state.getValue((Property)FACING)).getOpposite()) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> SHAPE_UP;
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
        };
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (context instanceof EntityCollisionContext) {
            EntityCollisionContext ec = (EntityCollisionContext)context;
            Entity entity = ec.getEntity();
            if (entity instanceof Projectile) {
                Projectile p = (Projectile)entity;
                if (p.tickCount < 40) {
                    return Shapes.empty();
                }
            }
            if (ec.getEntity() != null) {
                return super.getCollisionShape(state, level, pos, context);
            }
        }
        return Shapes.empty();
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> SHAPE_UP;
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
        };
    }

    public boolean hasAnalogOutputSignal(BlockState blockState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos blockPos) {
        int power = 0;
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)blockEntity;
            if (tile.isOnCooldown() || tile.isFiring()) {
                power += 15;
            }
            if (!tile.getProjectile().isEmpty()) {
                power += 8;
            }
            ItemStack ammo = tile.getFuel();
            int maxStackSize = ammo.getMaxStackSize();
            int ammoCount = ammo.getCount();
            int importantCount = Math.min(ammoCount, 4);
            power += importantCount;
            int nonImportantCount = maxStackSize - 4;
            float remainingPower = Mth.map((float)nonImportantCount, (float)0.0f, (float)(maxStackSize - 4), (float)0.0f, (float)3.0f);
            if (remainingPower > 0.0f) {
                power += (int)remainingPower;
            }
        }
        return Mth.clamp((int)power, (int)0, (int)15);
    }

    public Optional<BlockState> getRotatedState(BlockState state, LevelAccessor levelAccessor, BlockPos blockPos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        boolean ccw = rotation == Rotation.COUNTERCLOCKWISE_90;
        return BlockUtil.getRotatedDirectionalBlock(state, axis, ccw).or(() -> Optional.of(state));
    }

    public void onRotated(BlockState newState, BlockState oldState, LevelAccessor world, BlockPos pos, Rotation rotation, Direction axis, @Nullable Vec3 hit) {
        BlockEntity blockEntity;
        if (axis.getAxis() == ((Direction)newState.getValue((Property)FACING)).getAxis() && (blockEntity = world.getBlockEntity(pos)) instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)blockEntity;
            float angle = rotation.rotate(0, 4) * -90;
            Vector3f currentDir = tile.selfAccess.getCannonGlobalFacing(0.0f).toVector3f();
            Quaternionf q = new Quaternionf().rotateAxis(angle * ((float)Math.PI / 180), (Vector3fc)axis.step());
            currentDir.rotate((Quaternionfc)q);
            Vec3 newDir = new Vec3(currentDir);
            tile.setYaw(tile.selfAccess, (float)MthUtils.getYaw((Vec3)newDir));
            tile.setPitch(tile.selfAccess, (float)MthUtils.getPitch((Vec3)newDir));
            tile.setChanged();
            tile.getLevel().sendBlockUpdated(pos, oldState, newState, 3);
        }
    }

    @Override
    public void rotateAnalog(BlockState state, Level level, BlockPos pos, Direction face, boolean ccw, float speed) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CannonBlockTile) {
            CannonBlockTile tile = (CannonBlockTile)blockEntity;
            float deltaAngle = -(speed *= 0.01f) * (float)(ccw ? -1 : 1);
            Vector3f rotAxis = face.step();
            Vector3f facingVec = tile.selfAccess.getCannonGlobalFacing(0.0f).toVector3f();
            Quaternionf q = new Quaternionf().rotateAxis(deltaAngle, (Vector3fc)rotAxis);
            facingVec.rotate((Quaternionfc)q);
            Vec3 newDir = new Vec3(facingVec);
            tile.selfAccess.setCannonGlobalFacing(newDir, true);
            tile.setChanged();
        }
    }

    @Override
    public boolean canRotateAnalog(BlockState state, Level level, BlockPos pos, Direction face) {
        return ((Direction)state.getValue((Property)FACING)).getAxis() != face.getAxis();
    }
}

