/*
 * Decompiled with CFR 0.152.
 */
package fuzs.fantasticwings.world.effect;

import fuzs.fantasticwings.flight.FlightCapability;
import fuzs.fantasticwings.flight.apparatus.FlightApparatus;
import fuzs.fantasticwings.flight.apparatus.FlightApparatusImpl;
import fuzs.fantasticwings.init.ModRegistry;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.InstantenousMobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;

public class WingsMobEffect
extends InstantenousMobEffect {
    public WingsMobEffect(MobEffectCategory category, int color) {
        super(category, color);
    }

    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.level().isClientSide && livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (this.isBeneficial() ? WingsMobEffect.giveWings(serverPlayer, amplifier) : WingsMobEffect.takeWings(serverPlayer)) {
                serverPlayer.level().playSound(null, serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), (SoundEvent)ModRegistry.ITEM_ARMOR_EQUIP_WINGS.value(), SoundSource.PLAYERS, 1.0f, this.isBeneficial() ? 1.0f : 0.8f);
            }
        }
        return super.applyEffectTick(livingEntity, amplifier);
    }

    public static boolean giveWings(ServerPlayer serverPlayer, int wingsTypeId) {
        return WingsMobEffect.giveWings(serverPlayer, FlightApparatusImpl.byId(wingsTypeId).holder());
    }

    public static boolean giveWings(ServerPlayer serverPlayer, FlightApparatus.FlightApparatusHolder flightApparatus) {
        FlightCapability flightCapability = (FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)serverPlayer);
        if (!flightCapability.getWings().is(flightApparatus)) {
            flightCapability.setWings(flightApparatus);
            return true;
        }
        return false;
    }

    public static boolean takeWings(ServerPlayer serverPlayer) {
        return WingsMobEffect.takeWings(serverPlayer, FlightApparatus.FlightApparatusHolder.empty());
    }

    public static boolean takeWings(ServerPlayer serverPlayer, FlightApparatus.FlightApparatusHolder flightApparatus) {
        FlightCapability flightCapability = (FlightCapability)ModRegistry.FLIGHT_CAPABILITY.get((Object)serverPlayer);
        if (!flightCapability.getWings().isEmpty() && (flightApparatus.isEmpty() || flightCapability.getWings().is(flightApparatus))) {
            flightCapability.setWings(FlightApparatus.FlightApparatusHolder.empty());
            return true;
        }
        return false;
    }
}

