/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanicals.utility;

import com.oierbravo.mechanicals.Mechanicals;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class MechanicalConfigUtils {
    public static Ingredient readIngredient(String configValue, TagKey<Item> defaultValueTag) {
        Ingredient requiredItemIngredient;
        if (configValue.startsWith("#")) {
            ResourceLocation itemTag = ResourceLocation.tryParse((String)configValue.replace("#", ""));
            assert (itemTag != null);
            return Ingredient.of((TagKey)ItemTags.create((ResourceLocation)itemTag));
        }
        ResourceLocation desiredIngredient = ResourceLocation.parse((String)configValue);
        if (BuiltInRegistries.ITEM.containsKey(desiredIngredient)) {
            requiredItemIngredient = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)BuiltInRegistries.ITEM.get(desiredIngredient)});
        } else {
            Mechanicals.LOGGER.error("Unknown item '{}' in config, using default '{}' instead", (Object)configValue, defaultValueTag);
            requiredItemIngredient = Ingredient.of(defaultValueTag);
        }
        return requiredItemIngredient;
    }

    public static FluidStack readFluidStack(String configValue, int configAmount, String defaultValue) {
        FluidStack outputFluid;
        ResourceLocation desiredFluid = ResourceLocation.parse((String)configValue);
        if (BuiltInRegistries.FLUID.containsKey(desiredFluid)) {
            outputFluid = new FluidStack((Fluid)BuiltInRegistries.FLUID.get(desiredFluid), configAmount);
        } else {
            Mechanicals.LOGGER.error("Unknown fluid '{}' in config, using default '{}' instead", (Object)configValue, (Object)defaultValue);
            outputFluid = new FluidStack((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)defaultValue)), configAmount);
        }
        return outputFluid;
    }
}

