/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanicals.foundation.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.createmod.catnip.data.Pair;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class BlockPredicateUtils {

    public static class Matcher {
        public static final BlockPredicate EMPTY = new BlockPredicate(Optional.empty(), Optional.empty(), Optional.empty());
        final BlockPredicate blockPredicate;

        public Matcher(BlockPredicate blockPredicate) {
            this.blockPredicate = blockPredicate;
        }

        public static Matcher of(BlockPredicate blockPredicate) {
            return new Matcher(blockPredicate);
        }

        public boolean isEmpty() {
            if (this.blockPredicate == EMPTY) {
                return true;
            }
            return this.hasEmptyBlocks() && this.hasEmptyProperties() && this.hasEmptyNbt();
        }

        public boolean hasEmptyBlocks() {
            return this.blockPredicate.blocks().isEmpty();
        }

        public boolean hasEmptyProperties() {
            return this.blockPredicate.properties().isEmpty();
        }

        public boolean hasEmptyNbt() {
            return this.blockPredicate.nbt().isEmpty();
        }

        public List<Block> blocks() {
            if (this.isEmpty()) {
                return List.of();
            }
            ArrayList<Block> blocks = new ArrayList<Block>();
            if (this.blockPredicate.blocks().isPresent()) {
                for (Holder block : (Iterable)((HolderSet)this.blockPredicate.blocks().get()).unwrap().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.BLOCK).getOrCreateTag(arg_0), Function.identity())) {
                    blocks.add((Block)block.value());
                }
            }
            return blocks;
        }

        public List<Fluid> fluids() {
            return this.blocks().stream().filter(block -> block instanceof LiquidBlock).map(block -> ((LiquidBlock)block).fluid.getSource()).toList();
        }

        public List<FluidStack> fluidStacks() {
            return this.fluids().stream().map(fluid -> new FluidStack(fluid, 1000)).toList();
        }

        public List<Item> items() {
            if (this.isEmpty()) {
                return List.of();
            }
            return this.blocks().stream().map(Block::asItem).filter(item -> !item.equals(Items.AIR)).toList();
        }

        public List<ItemStack> itemStacks() {
            if (this.isEmpty()) {
                return List.of();
            }
            List<Item> items = this.items();
            return this.items().stream().map(Item::getDefaultInstance).toList();
        }
    }

    public static class Builder {
        public static <T extends Comparable<T>> BlockPredicate.Builder from(Block block, List<Pair<Property<T>, T>> properties) {
            BlockPredicate.Builder builder = BlockPredicate.Builder.block().of(new Block[]{block});
            StatePropertiesPredicate.Builder propBuilder = StatePropertiesPredicate.Builder.properties();
            properties.forEach(property -> propBuilder.hasProperty((Property)property.getFirst(), String.valueOf(property.getSecond())));
            return builder;
        }

        public static BlockPredicate.Builder from(Block block) {
            return BlockPredicate.Builder.block().of(new Block[]{block});
        }

        public static BlockPredicate.Builder from(ResourceLocation resourceLocation) {
            return Builder.from((Block)BuiltInRegistries.BLOCK.get(resourceLocation));
        }

        public static BlockPredicate.Builder from(String id) {
            return Builder.from((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)id)));
        }

        public static BlockPredicate build(Block block) {
            return Builder.from(block).build();
        }

        public static BlockPredicate build(ResourceLocation resourceLocation) {
            return Builder.build((Block)BuiltInRegistries.BLOCK.get(resourceLocation));
        }

        public static BlockPredicate build(String id) {
            return Builder.build(ResourceLocation.parse((String)id));
        }

        public static <T extends Comparable<T>> BlockPredicate build(Block block, List<Pair<Property<T>, T>> properties) {
            return Builder.from(block, properties).build();
        }

        public static <T extends Comparable<T>> BlockPredicate build(ResourceLocation resourceLocation, List<Pair<Property<T>, T>> properties) {
            return Builder.build((Block)BuiltInRegistries.BLOCK.get(resourceLocation), properties);
        }

        public static <T extends Comparable<T>> BlockPredicate build(String id, List<Pair<Property<T>, T>> properties) {
            return Builder.build(ResourceLocation.parse((String)id), properties);
        }
    }
}

