/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.mechanicals.foundation.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.oierbravo.mechanicals.foundation.gui.MechanicalGUITextures;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class EnergyDisplay
extends AbstractSimiWidget {
    private final IEnergyStorage energy;
    private final int xPos;
    private final int yPos;
    private final int width;
    private final int height;

    public EnergyDisplay(int x, int y, IEnergyStorage pEnergy) {
        super(x, y);
        this.xPos = x;
        this.yPos = y;
        this.width = 9;
        this.height = 30;
        this.energy = pEnergy;
    }

    protected void doRender(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float partialTicks) {
        if (this.visible) {
            this.isHovered = pMouseX >= this.getX() && pMouseY >= this.getY() && pMouseX < this.getX() + this.width && pMouseY < this.getY() + this.height;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawBg(pGuiGraphics, MechanicalGUITextures.RF_VERTIVAL_BAR);
            int stored = (int)((float)this.height * ((float)this.energy.getEnergyStored() / (float)this.energy.getMaxEnergyStored()));
            pGuiGraphics.fillGradient(this.xPos + 1, this.yPos + 1 + (this.height - stored), this.xPos + 1 + this.width, this.yPos - 1 + this.height, -4909824, -10482944);
            if (this.isHovered()) {
                Font font = Minecraft.getInstance().font;
                pGuiGraphics.renderTooltip(font, this.getTooltips(), Optional.empty(), pMouseX, pMouseY);
            }
        }
    }

    protected void drawBg(GuiGraphics graphics, MechanicalGUITextures background) {
        graphics.blit(background.location, this.getX(), this.getY(), background.startX, background.startY, background.width, background.height);
    }

    public List<Component> getTooltips() {
        return List.of(Component.literal((String)(this.energy.getEnergyStored() + " / " + this.energy.getMaxEnergyStored() + " FE")));
    }
}

