/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.neoforge.core.mixin;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.satisfy.farm_and_charm.core.item.HorseFodderItem;
import net.satisfy.farm_and_charm.core.registry.ObjectRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractHorse.class})
public class AbstractHorseMixin {
    @Inject(method={"isFood(Lnet/minecraft/world/item/ItemStack;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void addCustomFoodItems(ItemStack stack, CallbackInfoReturnable<Boolean> cir) {
        if (stack.is((Item)ObjectRegistry.BARLEY.get()) || stack.is((Item)ObjectRegistry.OAT.get())) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectCustomItemInteraction(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        AbstractHorse self = (AbstractHorse)this;
        ItemStack itemStack = player.getItemInHand(hand);
        if (!self.isTamed() && itemStack.getItem() instanceof HorseFodderItem) {
            if (!self.level().isClientSide) {
                self.tameWithName(player);
                itemStack.shrink(1);
            }
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        }
    }
}

