/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.network.packet;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.satisfy.farm_and_charm.core.block.entity.TextEditableBlockEntity;
import net.satisfy.farm_and_charm.core.network.PacketHandler;
import org.jetbrains.annotations.NotNull;

public record SetTextPacket(BlockPos pos, List<String> texts) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetTextPacket> TYPE = new CustomPacketPayload.Type(PacketHandler.SET_SIGN_TEXT);
    public static final StreamCodec<RegistryFriendlyByteBuf, SetTextPacket> STREAM_CODEC = StreamCodec.of(SetTextPacket::toNetwork, SetTextPacket::fromNetwork);

    public static void toNetwork(RegistryFriendlyByteBuf buf, SetTextPacket msg) {
        buf.writeBlockPos(msg.pos);
        buf.writeInt(msg.texts.size());
        for (String text : msg.texts) {
            buf.writeUtf(text);
        }
    }

    public static SetTextPacket fromNetwork(RegistryFriendlyByteBuf buf) {
        BlockPos pos = buf.readBlockPos();
        int size = buf.readInt();
        ArrayList<String> texts = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            texts.add(buf.readUtf(50));
        }
        return new SetTextPacket(pos, texts);
    }

    public static void handle(SetTextPacket msg, ServerPlayer player) {
        BlockEntity entity;
        Level level = player.level();
        if (level.isLoaded(msg.pos) && (entity = level.getBlockEntity(msg.pos)) instanceof TextEditableBlockEntity) {
            TextEditableBlockEntity editable = (TextEditableBlockEntity)entity;
            int maxLines = editable.getTextLineCount();
            for (int i = 0; i < Math.min(msg.texts.size(), maxLines); ++i) {
                editable.setText(i, (Component)Component.literal((String)msg.texts.get(i)));
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

