/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.item.food;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.satisfy.farm_and_charm.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;

public class EffectItem
extends Item {
    private final boolean returnBowl;

    public EffectItem(Item.Properties properties, int duration, boolean returnBowl) {
        super(properties);
        this.returnBowl = returnBowl;
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        ArrayList list2 = itemStack.has(DataComponents.FOOD) ? Objects.requireNonNull((FoodProperties)itemStack.get(DataComponents.FOOD)).effects() : Lists.newArrayList();
        ArrayList list3 = Lists.newArrayList();
        if (list2.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY));
        } else {
            for (FoodProperties.PossibleEffect statusEffectInstance : list2) {
                MutableComponent mutableText = Component.translatable((String)statusEffectInstance.effect().getDescriptionId());
                MobEffectInstance statusEffect = statusEffectInstance.effect();
                ((MobEffect)statusEffect.getEffect().value()).createModifiers(statusEffect.getAmplifier(), (holderx, attributeModifierx) -> {
                    AttributeModifier entityAttributeModifier = new AttributeModifier(attributeModifierx.id(), attributeModifierx.amount() * (double)(statusEffect.getAmplifier() + 1), attributeModifierx.operation());
                    list3.add(new Pair(holderx, (Object)entityAttributeModifier));
                });
                if (statusEffectInstance.effect().getDuration() > 20) {
                    mutableText = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutableText, MobEffectUtil.formatDuration((MobEffectInstance)statusEffect, (float)statusEffectInstance.probability(), (float)tooltipContext.tickRate())});
                }
                tooltip.add((Component)mutableText.withStyle(((MobEffect)statusEffect.getEffect().value()).getCategory().getTooltipFormatting()));
            }
        }
        if (!list3.isEmpty()) {
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
            for (Pair pair : list3) {
                AttributeModifier entityAttributeModifier3 = (AttributeModifier)pair.getSecond();
                double d = entityAttributeModifier3.amount();
                double e = entityAttributeModifier3.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_BASE && entityAttributeModifier3.operation() != AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? entityAttributeModifier3.amount() : entityAttributeModifier3.amount() * 100.0;
                if (d > 0.0) {
                    tooltip.add((Component)Component.translatable((String)("attribute.modifier.plus." + entityAttributeModifier3.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(e), Component.translatable((String)((Attribute)((Holder)pair.getFirst()).value()).getDescriptionId())}).withStyle(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d < 0.0)) continue;
                tooltip.add((Component)Component.translatable((String)("attribute.modifier.take." + entityAttributeModifier3.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(e *= -1.0), Component.translatable((String)((Attribute)((Holder)pair.getFirst()).value()).getDescriptionId())}).withStyle(ChatFormatting.RED));
            }
        }
    }

    @NotNull
    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity livingEntity) {
        ItemStack eaten = livingEntity.eat(level, itemStack);
        if (this.returnBowl) {
            return GeneralUtil.convertStackAfterFinishUsing(livingEntity, eaten, Items.BOWL, this);
        }
        return eaten;
    }
}

