/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.core.item.food;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class EffectFoodHelper {
    private static float saturationModifierOf(FoodProperties base) {
        if (base.nutrition() <= 0) {
            return 0.0f;
        }
        return base.saturation() / ((float)base.nutrition() * 2.0f);
    }

    public static void addEffect(ItemStack stack, Pair<MobEffectInstance, Float> effect) {
        FoodProperties base = (FoodProperties)stack.get(DataComponents.FOOD);
        if (base == null) {
            return;
        }
        Holder target = ((MobEffectInstance)effect.getFirst()).getEffect();
        for (FoodProperties.PossibleEffect e : base.effects()) {
            if (e.effect().getEffect() != target) continue;
            return;
        }
        FoodProperties.Builder b = new FoodProperties.Builder().nutrition(base.nutrition()).saturationModifier(EffectFoodHelper.saturationModifierOf(base));
        if (base.canAlwaysEat()) {
            b.alwaysEdible();
        }
        if (base.eatSeconds() == 0.8f) {
            b.fast();
        }
        for (FoodProperties.PossibleEffect e : base.effects()) {
            b.effect(e.effect(), e.probability());
        }
        b.effect((MobEffectInstance)effect.getFirst(), ((Float)effect.getSecond()).floatValue());
        stack.set(DataComponents.FOOD, (Object)b.build());
    }

    private static void rebuildWithout(ItemStack stack) {
        FoodProperties base = (FoodProperties)stack.get(DataComponents.FOOD);
        if (base == null) {
            return;
        }
        FoodProperties.Builder b = new FoodProperties.Builder().nutrition(base.nutrition()).saturationModifier(EffectFoodHelper.saturationModifierOf(base));
        if (base.canAlwaysEat()) {
            b.alwaysEdible();
        }
        if (base.eatSeconds() == 0.8f) {
            b.fast();
        }
        for (FoodProperties.PossibleEffect e : base.effects()) {
            if (e.effect().getEffect() == MobEffects.HUNGER) continue;
            b.effect(e.effect(), e.probability());
        }
        stack.set(DataComponents.FOOD, (Object)b.build());
    }

    private static void removeHungerEffect(ItemStack stack) {
        EffectFoodHelper.rebuildWithout(stack);
    }

    private static void removeRawChickenEffects(ItemStack stack) {
        if (stack.getItem() != Items.CHICKEN) {
            return;
        }
        EffectFoodHelper.removeHungerEffect(stack);
    }

    public static List<Pair<MobEffectInstance, Float>> getEffects(ItemStack stack) {
        EffectFoodHelper.removeHungerEffect(stack);
        EffectFoodHelper.removeRawChickenEffects(stack);
        ArrayList out = Lists.newArrayList();
        if (stack.getItem() instanceof PotionItem) {
            PotionContents pc = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
            pc.potion().ifPresent(p -> {
                for (MobEffectInstance e : ((Potion)p.value()).getEffects()) {
                    out.add(new Pair((Object)e, (Object)Float.valueOf(1.0f)));
                }
            });
            for (MobEffectInstance e : pc.customEffects()) {
                out.add(new Pair((Object)e, (Object)Float.valueOf(1.0f)));
            }
            return out;
        }
        FoodProperties base = (FoodProperties)stack.get(DataComponents.FOOD);
        if (base != null) {
            for (FoodProperties.PossibleEffect e : base.effects()) {
                out.add(new Pair((Object)e.effect(), (Object)Float.valueOf(e.probability())));
            }
        }
        return out;
    }

    public static void applyEffects(ItemStack stack) {
        PotionContents pc = (PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        if (pc.hasEffects()) {
            return;
        }
        FoodProperties base = (FoodProperties)stack.get(DataComponents.FOOD);
        if (base == null) {
            return;
        }
        FoodProperties.Builder b = new FoodProperties.Builder().nutrition(base.nutrition()).saturationModifier(EffectFoodHelper.saturationModifierOf(base));
        if (base.canAlwaysEat()) {
            b.alwaysEdible();
        }
        if (base.eatSeconds() == 0.8f) {
            b.fast();
        }
        for (FoodProperties.PossibleEffect e : base.effects()) {
            b.effect(e.effect(), e.probability());
        }
        stack.set(DataComponents.FOOD, (Object)b.build());
    }

    public static CompoundTag createNbt(short id, Pair<MobEffectInstance, Float> effect) {
        CompoundTag nbtCompound = new CompoundTag();
        nbtCompound.putShort("id", id);
        nbtCompound.putInt("duration", ((MobEffectInstance)effect.getFirst()).getDuration());
        nbtCompound.putInt("amplifier", ((MobEffectInstance)effect.getFirst()).getAmplifier());
        nbtCompound.putFloat("chance", ((Float)effect.getSecond()).floatValue());
        return nbtCompound;
    }

    public static List<Pair<MobEffectInstance, Float>> fromNbt(ListTag list) {
        ArrayList effects = Lists.newArrayList();
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag nbtCompound = list.getCompound(i);
            Optional effect = BuiltInRegistries.MOB_EFFECT.getHolder((int)nbtCompound.getShort("id"));
            effect.ifPresent(mobEffectReference -> effects.add(new Pair((Object)new MobEffectInstance((Holder)mobEffectReference, nbtCompound.getInt("duration"), nbtCompound.getInt("amplifier")), (Object)Float.valueOf(nbtCompound.getFloat("chance")))));
        }
        return effects;
    }

    public static ItemStack setStage(ItemStack stack, int stage) {
        stack.set(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(stage));
        return stack;
    }

    public static int getStage(ItemStack stack) {
        return ((CustomModelData)stack.getOrDefault(DataComponents.CUSTOM_MODEL_DATA, (Object)new CustomModelData(0))).value();
    }

    public static void getTooltip(ItemStack stack, Item.TooltipContext tooltipContext, List<Component> tooltip) {
        ArrayList effects = stack.has(DataComponents.FOOD) ? Objects.requireNonNull((FoodProperties)stack.get(DataComponents.FOOD)).effects() : Lists.newArrayList();
        ArrayList attrs = Lists.newArrayList();
        if (effects.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY));
            return;
        }
        for (FoodProperties.PossibleEffect pe : effects) {
            MutableComponent name = Component.translatable((String)pe.effect().getDescriptionId());
            MobEffect eff = (MobEffect)pe.effect().getEffect().value();
            eff.createModifiers(pe.effect().getAmplifier(), (h, base) -> {
                AttributeModifier m = new AttributeModifier(base.id(), base.amount() * (double)(pe.effect().getAmplifier() + 1), base.operation());
                attrs.add(new Pair(h, (Object)m));
            });
            if (pe.effect().getDuration() > 20) {
                name = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{name, MobEffectUtil.formatDuration((MobEffectInstance)pe.effect(), (float)pe.probability(), (float)tooltipContext.tickRate())});
            }
            tooltip.add((Component)name.withStyle(eff.getCategory().getTooltipFormatting()));
        }
        if (!attrs.isEmpty()) {
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"potion.whenDrank").withStyle(ChatFormatting.DARK_PURPLE));
            for (Pair pair : attrs) {
                double shown;
                AttributeModifier m = (AttributeModifier)pair.getSecond();
                double amt = m.amount();
                double d = shown = m.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_BASE || m.operation() == AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL ? amt * 100.0 : amt;
                if (amt > 0.0) {
                    tooltip.add((Component)Component.translatable((String)("attribute.modifier.plus." + m.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(shown), Component.translatable((String)((Attribute)((Holder)pair.getFirst()).value()).getDescriptionId())}).withStyle(ChatFormatting.BLUE));
                    continue;
                }
                if (!(amt < 0.0)) continue;
                tooltip.add((Component)Component.translatable((String)("attribute.modifier.take." + m.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(-shown), Component.translatable((String)((Attribute)((Holder)pair.getFirst()).value()).getDescriptionId())}).withStyle(ChatFormatting.RED));
            }
        }
    }

    public static Map<Holder<MobEffect>, MobEffectInstance> bestEffects(Iterable<Pair<MobEffectInstance, Float>> effects) {
        HashMap<Holder<MobEffect>, MobEffectInstance> best = new HashMap<Holder<MobEffect>, MobEffectInstance>();
        for (Pair<MobEffectInstance, Float> p : effects) {
            MobEffectInstance cur = (MobEffectInstance)p.getFirst();
            Holder key = cur.getEffect();
            MobEffectInstance prev = (MobEffectInstance)best.get(key);
            if (prev != null && cur.getAmplifier() <= prev.getAmplifier() && (cur.getAmplifier() != prev.getAmplifier() || cur.getDuration() <= prev.getDuration())) continue;
            best.put((Holder<MobEffect>)key, cur);
        }
        return best;
    }

    public static List<MobEffectInstance> collectMergedSortedEffects(Iterable<ItemStack> stacks) {
        ArrayList<Pair<MobEffectInstance, Float>> collected = new ArrayList<Pair<MobEffectInstance, Float>>();
        for (ItemStack in : stacks) {
            if (in.isEmpty()) continue;
            collected.addAll(EffectFoodHelper.getEffects(in));
        }
        Map<Holder<MobEffect>, MobEffectInstance> best = EffectFoodHelper.bestEffects(collected);
        ArrayList<MobEffectInstance> sorted = new ArrayList<MobEffectInstance>(best.values());
        sorted.sort(Comparator.comparingInt(a -> BuiltInRegistries.MOB_EFFECT.getId((Object)((MobEffect)a.getEffect().value()))));
        return sorted;
    }

    public static List<MobEffectInstance> collectMergedSortedEffects(Container container, int from, int to) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = from; i <= to; ++i) {
            stacks.add(container.getItem(i));
        }
        return EffectFoodHelper.collectMergedSortedEffects(stacks);
    }
}

